/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IRepositoryResourceWithStatusProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractToOperationRemote
extends AbstractActionOperation {
    private InitExtractLogOperation logger;
    private Collection<String> toDelete;
    private IRepositoryResourceProvider deletionsProvider;
    private IRepositoryResourceWithStatusProvider dataProvider;
    private String path;
    private boolean delitionAllowed;
    private HashMap<String, String> exportRoots2Names;

    public ExtractToOperationRemote(IRepositoryResource[] incomingResources, Map<String, String> statusesMap, Collection<String> markedForDelition, String path, HashMap<String, String> resource2projectNames, InitExtractLogOperation logger, boolean delitionAllowed) {
        this((IRepositoryResourceWithStatusProvider)new IRepositoryResourceWithStatusProvider.DefaultRepositoryResourceWithStatusProvider(incomingResources, statusesMap), markedForDelition, path, resource2projectNames, logger, delitionAllowed);
    }

    public ExtractToOperationRemote(IRepositoryResourceWithStatusProvider incomingResourcesProvider, Collection<String> markedForDelition, String path, HashMap<String, String> exportRoots2Names, InitExtractLogOperation logger, boolean delitionAllowed) {
        super("Operation_ExtractTo", SVNMessages.class);
        this.logger = logger;
        this.dataProvider = incomingResourcesProvider;
        this.path = path;
        this.delitionAllowed = delitionAllowed;
        this.toDelete = markedForDelition;
        this.exportRoots2Names = exportRoots2Names;
    }

    public ExtractToOperationRemote(IRepositoryResourceWithStatusProvider incomingResourcesProvider, IRepositoryResourceProvider markedForDelition, String path, HashMap<String, String> exportRoots2Names, InitExtractLogOperation logger, boolean delitionAllowed) {
        super("Operation_ExtractTo", SVNMessages.class);
        this.logger = logger;
        this.dataProvider = incomingResourcesProvider;
        this.path = path;
        this.delitionAllowed = delitionAllowed;
        this.deletionsProvider = markedForDelition;
        this.exportRoots2Names = exportRoots2Names;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int n;
        IRepositoryResource[] resources = this.dataProvider.getRepositoryResources();
        if (this.deletionsProvider != null) {
            IRepositoryResource[] deletions = this.deletionsProvider.getRepositoryResources();
            this.toDelete = new HashSet<String>();
            if (deletions != null) {
                IRepositoryResource[] iRepositoryResourceArray = deletions;
                n = deletions.length;
                int n2 = 0;
                while (n2 < n) {
                    IRepositoryResource deletion = iRepositoryResourceArray[n2];
                    this.toDelete.add(deletion.getUrl());
                    ++n2;
                }
            }
        }
        int processed = 0;
        SVNUtility.reorder(resources, true);
        HashMap<String, String> repoFolder2localFolder = new HashMap<String, String>();
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n3 = resources.length;
        n = 0;
        while (n < n3) {
            IRepositoryResource current = iRepositoryResourceArray[n];
            String currentURL = current.getUrl();
            IPath currentPath = SVNUtility.createPathForSVNUrl(currentURL);
            String toOperate = "";
            String rootUrl = null;
            String rootName = null;
            for (String url : this.exportRoots2Names.keySet()) {
                if (!SVNUtility.createPathForSVNUrl(url).isPrefixOf(currentPath)) continue;
                rootUrl = url;
                rootName = this.exportRoots2Names.get(url);
            }
            if (current instanceof IRepositoryContainer) {
                String localPath = "/" + (rootUrl == null ? current.getName() : current.getUrl().substring(rootUrl.lastIndexOf(47) + 1));
                repoFolder2localFolder.put(currentURL, localPath);
                toOperate = localPath;
            } else {
                String localFolderPath;
                String parentFolderURL = currentURL.substring(0, currentURL.lastIndexOf(47));
                if (!repoFolder2localFolder.containsKey(parentFolderURL)) {
                    localFolderPath = "/" + (rootUrl == null ? "" : parentFolderURL.substring(rootUrl.lastIndexOf(47) + 1));
                    repoFolder2localFolder.put(parentFolderURL, localFolderPath);
                } else {
                    localFolderPath = (String)repoFolder2localFolder.get(parentFolderURL);
                }
                toOperate = "/" + localFolderPath + currentURL.substring(currentURL.lastIndexOf(47));
            }
            if (rootUrl != null) {
                String projectRepoName = rootUrl.substring(rootUrl.lastIndexOf("/") + 1);
                int idx = toOperate.indexOf(projectRepoName);
                toOperate = String.valueOf(toOperate.substring(0, idx)) + rootName + toOperate.substring(idx + projectRepoName.length());
            }
            toOperate = String.valueOf(this.path) + toOperate;
            File operatingDirectory = new File(toOperate);
            String status = this.dataProvider.getStatusesMap().get(currentURL);
            if (status != null) {
                this.logger.log(operatingDirectory.getAbsolutePath().substring(this.path.length() + 1), status);
            }
            if (this.toDelete.contains(current.getUrl())) {
                if (operatingDirectory.exists() && this.delitionAllowed) {
                    FileUtility.deleteRecursive(operatingDirectory);
                }
            } else if (current instanceof IRepositoryContainer) {
                monitor.subTask(SVNMessages.format(SVNMessages.Operation_ExtractTo_Folders, new String[]{currentURL}));
                operatingDirectory.mkdirs();
            } else {
                monitor.subTask(SVNMessages.format(SVNMessages.Operation_ExtractTo_Folders, new String[]{currentURL}));
                if (operatingDirectory.getParentFile() != null) {
                    operatingDirectory.getParentFile().mkdirs();
                }
                monitor.subTask(SVNMessages.format(SVNMessages.Operation_ExtractTo_RemoteFile, new String[]{currentURL}));
                this.downloadFile(current, toOperate, monitor);
            }
            ProgressMonitorUtility.progress(monitor, processed++, resources.length);
            ++n;
        }
    }

    protected void downloadFile(IRepositoryResource remote, String downloadPath, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = remote.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            FileOutputStream stream = new FileOutputStream(downloadPath);
            try {
                proxy.streamFileContent(SVNUtility.getEntryRevisionReference(remote), 2048, stream, new SVNProgressMonitor(this, monitor, null));
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    @Override
    public int getOperationWeight() {
        if (this.dataProvider.getRepositoryResources() != null && this.dataProvider.getRepositoryResources().length == 0) {
            return 0;
        }
        return 4;
    }
}

