/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ReplaceWithRemoteOperation
extends AbstractActionOperation {
    protected IResource toReplace;
    protected IRepositoryResource remoteRoot;
    protected boolean ignoreExternals;

    public ReplaceWithRemoteOperation(IResource toReplace, IRepositoryResource remoteResource, boolean ignoreExternals) {
        super("Operation_ReplaceWithRemote", SVNMessages.class);
        this.toReplace = toReplace;
        this.remoteRoot = remoteResource;
        this.ignoreExternals = ignoreExternals;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = this.remoteRoot.getRepositoryLocation();
        String toReplacePath = FileUtility.getWorkingCopyPath(this.toReplace);
        File f = File.createTempFile("svn", "");
        f.delete();
        String tempPath = String.valueOf(toReplacePath.substring(0, toReplacePath.lastIndexOf("/") + 1)) + f.getName() + "/";
        ISVNConnector proxy = location.acquireSVNProxy();
        String path = String.valueOf(tempPath) + this.remoteRoot.getName();
        SVNEntryRevisionReference entryRef = SVNUtility.getEntryRevisionReference(this.remoteRoot);
        try {
            long options = 4L;
            if (this.ignoreExternals) {
                options |= 1L;
            }
            proxy.doExport(entryRef, path, null, 3, options, new SVNProgressMonitor(this, monitor, null));
            if (this.toReplace instanceof IFile) {
                FileUtility.copyFile(new File(toReplacePath), new File(path), monitor);
            } else {
                this.performReplacementRecursively(toReplacePath, path, proxy, monitor);
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
            FileUtility.deleteRecursive(new File(tempPath));
        }
    }

    protected void performReplacementRecursively(String pathForReplacement, String sourcePath, ISVNConnector connectorProxy, IProgressMonitor monitor) throws Exception {
        File dirToReplace = new File(pathForReplacement);
        File sourceDir = new File(sourcePath);
        ArrayList<String> toReplaceChildren = new ArrayList<String>();
        String[] children = dirToReplace.list();
        if (children != null) {
            toReplaceChildren.addAll(Arrays.asList(children));
        }
        children = sourceDir.list();
        ArrayList<String> sourceChildren = new ArrayList<String>();
        if (children != null) {
            sourceChildren.addAll(Arrays.asList(children));
        }
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        for (String currentToReplace : toReplaceChildren) {
            if (currentToReplace.equalsIgnoreCase(".svn") || sourceChildren.contains(currentToReplace)) continue;
            pathsToDelete.add(String.valueOf(pathForReplacement) + "/" + currentToReplace);
        }
        connectorProxy.remove(pathsToDelete.toArray(new String[0]), "", 4L, null, new SVNProgressMonitor(this, monitor, null));
        for (String currentFromSource : sourceChildren) {
            File toReplace = new File(String.valueOf(pathForReplacement) + "/" + currentFromSource);
            File source = new File(String.valueOf(sourcePath) + "/" + currentFromSource);
            if (source.isDirectory()) {
                if (!toReplace.exists()) {
                    toReplace.mkdir();
                }
                this.performReplacementRecursively(String.valueOf(pathForReplacement) + "/" + currentFromSource, String.valueOf(sourcePath) + "/" + currentFromSource, connectorProxy, monitor);
                continue;
            }
            FileUtility.copyFile(toReplace, source, monitor);
        }
    }
}

