/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.resource;

import java.io.Serializable;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SSLSettings
implements Serializable {
    private static final long serialVersionUID = -5649960025841815445L;
    protected boolean authenticationEnabled;
    protected String certificatePath = "";
    protected boolean passPhraseSaved = false;
    protected String passPhrase = "";
    private transient String passPhraseTemporary;

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getPassPhrase() {
        return this.passPhraseSaved ? SVNUtility.base64Decode(this.passPhrase) : SVNUtility.base64Decode(this.passPhraseTemporary);
    }

    public void setPassPhrase(String passPhrase) {
        if (this.passPhraseSaved) {
            this.passPhrase = SVNUtility.base64Encode(passPhrase);
        } else {
            this.passPhraseTemporary = SVNUtility.base64Encode(passPhrase);
        }
    }

    public boolean isPassPhraseSaved() {
        return this.passPhraseSaved;
    }

    public void setPassPhraseSaved(boolean passPhraseSaved) {
        if (this.passPhraseSaved == passPhraseSaved) {
            return;
        }
        this.passPhraseSaved = passPhraseSaved;
        if (!passPhraseSaved) {
            this.passPhraseTemporary = this.passPhrase;
            this.passPhrase = null;
        } else {
            this.passPhrase = this.passPhraseTemporary;
        }
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }
}

