/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.lock.LocksComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAction
extends AbstractRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        IResource[] filteredResources;
        ArrayList<IResource> filteredResourcesList = new ArrayList<IResource>();
        IResource[] iResourceArray = filteredResources = this.getSelectedResourcesRecursive(IStateFilter.SF_VERSIONED);
        int n = filteredResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource filteredResource = iResourceArray[n2];
            if (filteredResource.getType() == 1 && filteredResource.getLocation() != null) {
                filteredResourcesList.add(filteredResource);
            }
            ++n2;
        }
        List<LockResource> lockResources = LockAction.getLockResources(filteredResourcesList.toArray(new IResource[0]));
        if (lockResources != null) {
            Iterator<LockResource> iter = lockResources.iterator();
            while (iter.hasNext()) {
                LockResource lockResource = iter.next();
                if (lockResource.getLockStatus() != LockResource.LockStatusEnum.LOCALLY_LOCKED) continue;
                iter.remove();
            }
            IActionOperation op = LocksComposite.performLockAction(lockResources.toArray(new LockResource[0]), false, this.getShell());
            if (op != null) {
                this.runScheduled(op);
            }
        }
    }

    public static List<LockResource> getLockResources(IResource[] resourcesToProcess) {
        ArrayList<LockResource> res = new ArrayList<LockResource>();
        IResource[] iResourceArray = resourcesToProcess;
        int n = resourcesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
            LockResource lr = local.isLocked() ? new LockResource(resource.getName(), null, true, LockResource.LockStatusEnum.LOCALLY_LOCKED, null, null, FileUtility.getWorkingCopyPath((IResource)resource), null) : LockResource.createNotLockedFile(resource.getName(), FileUtility.getWorkingCopyPath((IResource)resource));
            if (resource.getParent() != null) {
                String parentPath = resource.getParent().getFullPath().toString();
                if (parentPath.startsWith("/")) {
                    parentPath = parentPath.substring(1);
                }
                LockResource directory = LockResource.createDirectory(parentPath);
                directory.addChild(lr);
                res.add(lr);
            }
            ++n2;
        }
        return res;
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(IStateFilter.SF_READY_TO_LOCK);
    }
}

