/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.ComparePanel;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;
import org.eclipse.team.svn.ui.compare.ThreeWayResourceCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CompareResourcesInternalOperation
extends AbstractActionOperation {
    protected ILocalResource local;
    protected IRepositoryResource ancestor;
    protected IRepositoryResource remote;
    protected boolean showInDialog;
    protected boolean forceReuse;
    protected String forceId;

    public CompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote) {
        this(local, remote, false, false);
    }

    public CompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse) {
        this(local, remote, forceReuse, false);
    }

    public CompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse, boolean showInDialog) {
        super("Operation_CompareLocal", SVNUIMessages.class);
        this.local = local;
        this.ancestor = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)local.getResource()) : SVNRemoteStorage.instance().asRepositoryResource(local.getResource());
        this.ancestor.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)local.getBaseRevision()));
        this.remote = remote;
        this.showInDialog = showInDialog;
        this.forceReuse = forceReuse;
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ArrayList localChanges = new ArrayList();
        final ArrayList remoteChanges = new ArrayList();
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.local.getResource());
        final ISVNConnector proxy = location.acquireSVNProxy();
        final IRepositoryResource[] diffPair = new IRepositoryResource[]{this.ancestor, this.remote};
        SVNRevision revision = this.remote.getSelectedRevision();
        boolean fetchRemote = revision.getKind() == 7 || revision.getKind() == 1;
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                proxy.status(FileUtility.getWorkingCopyPath((IResource)CompareResourcesInternalOperation.this.local.getResource()), 3, 1L, null, new ISVNEntryStatusCallback(){

                    public void next(SVNChangeStatus status) {
                        localChanges.add(new SVNDiffStatus(status.path, status.path, status.nodeKind, status.textStatus, status.propStatus));
                    }
                }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
            }
        }, monitor, 100, fetchRemote ? 5 : 60);
        if (!monitor.isCanceled() && fetchRemote) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(diffPair);
                    ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
                    if (op.getExecutionState() != 0) {
                        CompareResourcesInternalOperation.this.reportStatus(op.getStatus());
                        return;
                    }
                    diffPair[0] = op.getRepositoryResources()[0];
                    diffPair[1] = op.getRepositoryResources()[1];
                }
            }, monitor, 100, 55);
            if (this.getExecutionState() == 1) {
                return;
            }
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)CompareResourcesInternalOperation.this, (String)SVNMessages.Progress_Running);
                    SVNEntryRevisionReference refPrev = SVNUtility.getEntryRevisionReference((IRepositoryResource)diffPair[0]);
                    SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)diffPair[1]);
                    if (SVNUtility.useSingleReferenceSignature((SVNEntryRevisionReference)refPrev, (SVNEntryRevisionReference)refNext)) {
                        SVNUtility.diffStatus((ISVNConnector)proxy, (Collection)remoteChanges, (SVNEntryReference)refPrev, (SVNRevision)refPrev.revision, (SVNRevision)refNext.revision, (int)3, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
                    } else {
                        SVNUtility.diffStatus((ISVNConnector)proxy, (Collection)remoteChanges, (SVNEntryRevisionReference)refPrev, (SVNEntryRevisionReference)refNext, (int)3, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
                    }
                }
            }, monitor, 100, 5);
        }
        location.releaseSVNProxy(proxy);
        if (!monitor.isCanceled()) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
                    diffPair[0].setSelectedRevision(SVNRevision.BASE);
                    final ThreeWayResourceCompareInput compare = new ThreeWayResourceCompareInput(cc, CompareResourcesInternalOperation.this.local, diffPair[0], diffPair[1], localChanges, remoteChanges);
                    compare.setForceId(CompareResourcesInternalOperation.this.forceId);
                    compare.initialize(monitor);
                    if (!monitor.isCanceled()) {
                        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                if ((this).CompareResourcesInternalOperation.this.showInDialog) {
                                    if (CompareResourcesInternalOperation.this.compareResultOK(compare)) {
                                        ComparePanel panel = new ComparePanel(compare, (this).CompareResourcesInternalOperation.this.local.getResource());
                                        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                                        dialog.open();
                                    }
                                } else {
                                    ResourceCompareInput.openCompareEditor(compare, (this).CompareResourcesInternalOperation.this.forceReuse);
                                }
                            }
                        });
                    }
                }
            }, monitor, 100, 40);
        }
    }

    protected boolean compareResultOK(CompareEditorInput input) {
        block5: {
            Shell shell = UIMonitorUtility.getShell();
            try {
                SVNTeamUIPlugin.instance().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
                String message = input.getMessage();
                if (message != null) {
                    MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)message);
                    break block5;
                }
                if (input.getCompareResult() == null) {
                    MessageDialog.openInformation((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.dialogTitle"), (String)Utilities.getString((String)"CompareUIPlugin.noDifferences"));
                    break block5;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException x) {
                MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
            }
        }
        return false;
    }
}

