/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.SVNContainerSelectionGroup;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class ContainerSelectionPanel
extends AbstractDialogPanel {
    protected ContainerSelectionGroup group;
    protected Button copyWithHistoryButton;
    protected IContainer initialRoot;
    protected Text nameBox;
    protected Button overrideResourceNameButton;
    protected IResource[] resources;
    protected IPath selectedPath;
    protected String defaultConflictMessage;
    protected int numConflicts;
    protected boolean copyWithHistorySelected;
    protected String name;
    protected boolean overrideResourceName;

    public ContainerSelectionPanel(IResource[] resources, HashSet conflicts) {
        this.dialogTitle = SVNUIMessages.ContainerSelectionPanel_Title;
        this.dialogDescription = SVNUIMessages.ContainerSelectionPanel_Description;
        this.selectedPath = null;
        this.initialRoot = resources[0].getParent();
        this.resources = resources;
        this.numConflicts = conflicts.size();
        this.defaultConflictMessage = "";
        this.getDefaultConflictMessage(conflicts);
        this.defaultConflictMessage = this.getDefaultConflictMessage(conflicts);
        this.defaultMessage = conflicts.size() == 0 ? SVNUIMessages.ContainerSelectionPanel_Message : this.defaultConflictMessage;
    }

    public IPath getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isOverrideResourceName() {
        return this.overrideResourceName;
    }

    public String getOverridenName() {
        return this.name;
    }

    public boolean isCopyWithHistorySelected() {
        return this.copyWithHistorySelected;
    }

    public void createControlsImpl(Composite parent) {
        GridData data = null;
        this.group = new SVNContainerSelectionGroup(parent, new Listener(){

            public void handleEvent(Event event) {
                ContainerSelectionPanel.this.validateContent();
            }
        });
        this.group.setLayoutData((Object)new GridData(1808));
        this.attachTo((Control)this.group, new ContainerSelectionVerifier(this.defaultConflictMessage));
        this.overrideResourceNameButton = new Button(parent, 32);
        this.overrideResourceNameButton.setLayoutData((Object)new GridData());
        this.overrideResourceNameButton.setText(SVNUIMessages.ContainerSelectionPanel_NewName);
        this.overrideResourceNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionPanel.this.nameBox.setEnabled(((Button)e.widget).getSelection());
                ContainerSelectionPanel.this.validateContent();
            }
        });
        this.overrideResourceNameButton.setSelection(false);
        this.nameBox = new Text(parent, 2052);
        data = new GridData(768);
        this.nameBox.setLayoutData((Object)data);
        this.nameBox.setText(this.resources[0].getName());
        this.nameBox.setEnabled(false);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNUIMessages.ContainerSelectionPanel_NewName_Verifier;
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ResourceNameVerifier(name, true));
        verifier.add(new AbstractFormattedVerifier(name){

            protected String getWarningMessageImpl(Control input) {
                return null;
            }

            protected String getErrorMessageImpl(Control input) {
                IPath path = ContainerSelectionPanel.this.group.getContainerFullPath();
                if (path != null && ResourcesPlugin.getWorkspace().getRoot().findMember(path.append(this.getText(input))) != null) {
                    return SVNUIMessages.ContainerSelectionPanel_NewName_Verifier_Error;
                }
                return null;
            }
        });
        this.attachTo((Control)this.nameBox, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return ContainerSelectionPanel.this.overrideResourceNameButton.getSelection();
            }
        });
        this.copyWithHistoryButton = new Button(parent, 32);
        this.copyWithHistoryButton.setLayoutData((Object)new GridData());
        this.copyWithHistoryButton.setText(SVNUIMessages.ContainerSelectionPanel_KeepHistory);
        this.copyWithHistoryButton.setSelection(true);
        this.copyWithHistoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionPanel.this.validateContent();
            }
        });
    }

    public void postInit() {
        super.postInit();
        if (this.initialRoot != null) {
            this.group.setSelectedContainer(this.initialRoot);
        }
        if (this.numConflicts == 0) {
            this.manager.setMessage(0, null);
        } else {
            this.manager.setMessage(1, null);
        }
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.copyMoveToDialogContext";
    }

    protected void saveChangesImpl() {
        this.selectedPath = this.group.getContainerFullPath();
        this.copyWithHistorySelected = this.copyWithHistoryButton.getSelection();
        this.name = this.nameBox.getText().trim();
        this.overrideResourceName = this.overrideResourceNameButton.getSelection();
    }

    protected void cancelChangesImpl() {
    }

    protected String getDefaultConflictMessage(HashSet conflicts) {
        if (conflicts.size() == 0) {
            return null;
        }
        int numberOfConflicts = 0;
        String message = "";
        for (String element : conflicts) {
            if (++numberOfConflicts >= 4) continue;
            message = String.valueOf(message) + (numberOfConflicts == 1 ? "'" + element + "'" : ", '" + element + "'");
        }
        if (numberOfConflicts >= 4) {
            message = String.valueOf(message) + "...";
        }
        return SVNUIMessages.format((String)SVNUIMessages.ContainerSelectionPanel_ConflictMessage, (Object[])new String[]{message});
    }

    public class ContainerSelectionVerifier
    extends SVNContainerSelectionGroup.SVNContainerSelectionVerifier {
        protected String SOME_RESOURCES_IN_CONFLICT_MESSAGE;
        protected String SOME_RESOURCE_IN_CONFLICT_MESSAGE;
        protected String ALL_RESOURCES_IN_CONFLICT_MESSAGE;
        protected String conflictedResources = "";
        protected String defaultConflictingResourcesNames;

        public ContainerSelectionVerifier(String conflictingResourcesNames) {
            this.defaultConflictingResourcesNames = conflictingResourcesNames;
            this.ALL_RESOURCES_IN_CONFLICT_MESSAGE = SVNUIMessages.ContainerSelectionPanel_Selection_Verifier_AllInConflict;
            this.SOME_RESOURCE_IN_CONFLICT_MESSAGE = SVNUIMessages.ContainerSelectionPanel_Selection_Verifier_SomeInConflict_Single;
            this.SOME_RESOURCES_IN_CONFLICT_MESSAGE = SVNUIMessages.ContainerSelectionPanel_Selection_Verifier_SomeInConflict_Multi;
        }

        protected String getErrorMessageImpl(Control input) {
            SVNContainerSelectionGroup control = (SVNContainerSelectionGroup)input;
            if (this.findConflicts(control) == ContainerSelectionPanel.this.resources.length) {
                return this.ALL_RESOURCES_IN_CONFLICT_MESSAGE;
            }
            return super.getErrorMessageImpl(input);
        }

        protected String getWarningMessageImpl(Control input) {
            SVNContainerSelectionGroup control = (SVNContainerSelectionGroup)input;
            int numberconflicts = this.findConflicts(control);
            if (numberconflicts == 1) {
                return BaseMessages.format((String)this.SOME_RESOURCE_IN_CONFLICT_MESSAGE, (Object[])new Object[]{this.conflictedResources});
            }
            if (numberconflicts > 1) {
                return BaseMessages.format((String)this.SOME_RESOURCES_IN_CONFLICT_MESSAGE, (Object[])new Object[]{this.conflictedResources});
            }
            if (this.defaultConflictingResourcesNames != null) {
                return this.defaultConflictingResourcesNames;
            }
            return null;
        }

        protected int findConflicts(SVNContainerSelectionGroup control) {
            IPath containerPath = control.getContainerFullPath();
            if (containerPath == null) {
                return 0;
            }
            if (ContainerSelectionPanel.this.overrideResourceNameButton.getSelection()) {
                containerPath = containerPath.append(ContainerSelectionPanel.this.nameBox.getText().trim());
                if (ContainerSelectionPanel.this.resources.length == 1 && ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath) != null) {
                    this.conflictedResources = containerPath.lastSegment();
                    return 1;
                }
            }
            ArrayList<IResource> destResources = new ArrayList<IResource>();
            int numberOfConflictedResources = 0;
            int i = 0;
            while (i < ContainerSelectionPanel.this.resources.length) {
                IPath dest = containerPath.append(ContainerSelectionPanel.this.resources[i].getName());
                IResource destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(dest);
                if (destinationResource != null) {
                    ++numberOfConflictedResources;
                    destResources.add(destinationResource);
                }
                ++i;
            }
            this.conflictedResources = FileUtility.getNamesListAsString((Object[])destResources.toArray());
            return numberOfConflictedResources;
        }

        protected boolean isNonSVNCheckDisabled() {
            return ContainerSelectionPanel.this.copyWithHistoryButton.getSelection();
        }
    }
}

