#!/bin/sh
#
# ACVersion.sh - Display the Agent Controller version number
#

#
# If TPTP_AC_HOME is not set then set it to the parent directory of the directory containing this script
#
if [ -z "$TPTP_AC_HOME" ]; then
	TPTP_AC_HOME=`dirname "$0"`/..
	export TPTP_AC_HOME
fi
PATH="$TPTP_AC_HOME/bin":$PATH
export PATH

#
# Set the library path(s)
#
LD_LIBRARY_PATH="$TPTP_AC_HOME/lib":$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

#
# Bug 175696, 201989
# Make sure TEMP dir is set
#
if [[ -n $TEMP ]]; then
	if [[ -d $TEMP ]]; then
		echo
	else
		export TEMP=/tmp
	fi
else
	export TEMP=/tmp
fi

#
# Show the version number
#
ACServer -v
