#!/bin/sh

#
# Check if java is in the PATH
#
java -version > /dev/null 2>&1
if [ $? != 0 ]; then
	echo 'ERROR: Cannot find java in the PATH'
	echo 'RESOLUTION: Make sure the PATH environment variable contains the location of a java executable'
	exit 0
fi


if [ ! -s ../../../org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430/config.jar ]; then
	echo 'ERROR:  Cannot find ..\lib\config.jar.'
	echo 'RESOLUTION: Make sure you are running this script in <AC>/bin directory.'
	exit 0
fi

#
# Check for com.ibm.icu in any /eclipse/plugins folders on the path
#
path_elements=`pwd | sed "s:/: :g"`
dir_path=""
for dir in $path_elements
do
	if [ -s $dir_path/$dir/plugins/com.ibm.icu_* ]
	then
		icu_prefix=$dir_path/$dir/plugins
		icu_name=`ls $icu_prefix | grep "com.ibm.icu_"`
		break
	else
		dir_path=$dir_path/$dir
	fi
done

if [ ! $icu_prefix ]
then
	echo 'ERROR:  Cannot find com.ibm.icu_<date>.jar.'
	echo 'RESOLUTION: Make sure you are running this script in <AC>/bin directory and that com.ibm.icu.<date>.jar exists.'
	exit 0
fi

#
# Check if the JRE contains a suitable JAXP
#
java -classpath $icu_prefix/$icu_name:../../../org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430/config.jar org.eclipse.tptp.platform.agentcontroller.config.TestJAXP > /dev/null 2>&1
if [ $? != 0 ]; then
	echo 'ERROR: The Java Runtime in use does not contain a suitable JAXP feature'
	echo 'RESOLUTION: Use a JRE which supports the JAXP feature'
	exit 0
fi

#
# Generate the configuration files
#
java -classpath $icu_prefix/$icu_name:../../../org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430/config.jar:../../../org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430/config.nl1.jar:../../../org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430/config.nl2.jar:../../../org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430/config.nl2a.jar org.eclipse.tptp.platform.agentcontroller.config.SetConfig $*


#
# Change the owner of ChkPass so that Agent Controller does not need root access for authenticating user passwords
#
RAC_SECURED=`grep -c '<Security ' ../config/serviceconfig.xml`
AC_SECURED=`grep -c '<SecurityEnabled>true' ../config/serviceconfig.xml`
SECURED=`expr $RAC_SECURED + $AC_SECURED`
if [ "$SECURED" = "0" ]; then
	echo
else
	ZOSHOSTCHECK=`uname`
	if [ "$ZOSHOSTCHECK" = "OS/390" ]; then
		echo
		echo Security has been enabled. BPX.DAEMON is required for agent controller security on z/OS. 
		echo Please speak with your system administrator to ensure the agent controller binaries and libraries have the appropriate privileges.
		echo Consult the included getting_started.html file for additional information on what is required.   
		echo		
	else
		echo
		echo 'Agent Controller has been configured for security.'
		echo 'Please enter root password to enable that security:'
		su root -c "chown root ChkPass;chmod +s ChkPass"
	fi
fi
