@rem *********************************************************************
@rem Copyright (c) 2005, 2009 IBM Corporation and others.
@rem All rights reserved.   This program and the accompanying materials
@rem are made available under the terms of the Eclipse Public License v1.0
@rem which accompanies this distribution, and is available at
@rem http://www.eclipse.org/legal/epl-v10.html
@rem $Id:$
@rem
@rem Contributors:
@rem IBM - Initial API and implementation
@rem *********************************************************************
@rem
@REM
@REM Check if java is in the PATH
@REM
@java -version > nul 2>&1
@IF ERRORLEVEL 1 GOTO ERROR_JAVA_NOT_FOUND

@REM
@REM Check if the script is run in <AC>/bin directory.
@REM
@if not exist ..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.jar GOTO ERROR_CONFIG_NOT_FOUND


@REM
@REM Find com.ibm.icu_<date>.jar if it's under an eclipse/plugins folder shared by the working dir.
@REM

@SET PREV_DIR=%CD%
@PUSHD ..

:DIR_SEARCH
@if exist plugins\com.ibm.icu_* (
CD plugins
@SET PREFIX="%CD%"\plugins
@FOR /F "tokens=*" %%G IN ('DIR /b com.ibm.icu_*') DO @SET JAR_NAME=%%G
@POPD
@GOTO ASSIGN_CLASS
)
@CD ..
@IF "%CD%" EQU "%PREV_DIR%" (
@POPD
@GOTO DIR_SEARCH_ERROR
)
@SET PREV_DIR=%CD%
@GOTO DIR_SEARCH

:ASSIGN_CLASS
@REM Check if the JRE contains a suitable JAXP
@java -classpath %PREFIX%\%JAR_NAME%;..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.jar org.eclipse.tptp.platform.agentcontroller.config.TestJAXP > nul 2>&1
@IF ERRORLEVEL 1 GOTO ERROR_JAXP_NOT_SUPPORTED

@REM
@REM Generate the configuration files
@REM
@java -classpath %PREFIX%\%JAR_NAME%;..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.jar;..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.nl1.jar;..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.nl2.jar;..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.nl2a.jar org.eclipse.tptp.platform.agentcontroller.config.SetConfig %*
@goto END

:ERROR_JAVA_NOT_FOUND
@echo "ERROR: Cannot find java in the PATH"
@echo "RESOLUTION: Make sure the PATH environment variable contains the location of a java executable"
@goto END

:ERROR_CONFIG_NOT_FOUND
@echo "ERROR:  Cannot find ..\..\..\org.eclipse.tptp.platform.agentcontroller_4.3.3.v201102041430\config.jar."
@echo "RESOLUTION: Make sure you are running this script in <AC>/bin directory."
@goto END

:ERROR_JAXP_NOT_SUPPORTED
@echo "ERROR: The Java Runtime in use does not contain a suitable JAXP feature"
@echo "RESOLUTION: Use a JRE which supports the JAXP feature"
@goto END

:DIR_SEARCH_ERROR
@ECHO "ERROR: Cannot find com.ibm.icu_<date>.jar."
@ECHO "RESOLUTION: Make sure you are running this script in <AC>/bin directory and that com.ibm.icu.<date>.jar exists in a eclipse/plugins dir higer than current dir."
@GOTO END

:END
