/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.wizard.NavigatorWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenWizardAction
extends SelectionProviderAction {
    protected Class fWizardClass;
    protected INavigator fViewer;

    public OpenWizardAction(INavigator viewer, Class wizardclass, String label) {
        super((ISelectionProvider)viewer.getViewer(), label);
        this.fWizardClass = wizardclass;
        this.fViewer = viewer;
    }

    public void run() {
        try {
            IWorkbench workbench = CommonUITracePlugin.getDefault().getWorkbench();
            NavigatorWizard wizard = (NavigatorWizard)((Object)this.fWizardClass.newInstance());
            WizardDialog dialog = new WizardDialog(this.fViewer.getViewSite().getShell(), (IWizard)wizard);
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getViewer().getSelection();
            if (wizard instanceof INewWizard) {
                wizard.init(workbench, selection);
            }
            wizard.setViewer(this.fViewer);
            dialog.open();
            ProfileEvent event = TraceUIManager.getTraceUIManager().getRefreshViewEvent((Object)selection);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fWizardClass = null;
    }
}

