/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.internal.util.SaveUtil;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class SaveAction
extends SelectionProviderAction
implements ISelectionChangedListener,
IRunnableWithProgress {
    protected INavigator fViewer;
    protected Object[] fSelections;

    public SaveAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), CommonUITraceMessages.SAVE);
        this.setDescription(Action.removeMnemonics((String)CommonUITraceMessages.SAVE));
        CommonUIImages.setActionImage((ImageManager)CommonUITraceImages.INSTANCE, (IAction)this, (String)"save.gif");
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.tptp.platform.common.ui.trace.save0000");
    }

    public void run() {
        String msg = "";
        ISelection sel = this.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        if (sel != null && !sel.isEmpty()) {
            msg = ((IStructuredSelection)sel).size() == 1 && ((IStructuredSelection)sel).getFirstElement() != null && ((IStructuredSelection)sel).getFirstElement() instanceof IProject ? CommonUITraceMessages.SAVE_PQ : CommonUITraceMessages.SAVE_RQ;
        }
        if (!MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)CommonUITraceMessages.TRC_MSGT, (String)msg)) {
            return;
        }
        this.finishSaving(((IStructuredSelection)sel).toArray());
    }

    public void finishSaving(Object[] selections) {
        this.fSelections = selections;
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this));
        }
        catch (InterruptedException interruptedException) {
            try {
                ArrayList<IResource> folders = new ArrayList<IResource>();
                int idx = 0;
                while (idx < this.fSelections.length) {
                    IResource res = HyadesUtil.getSelectionFolder((Object)this.fSelections[idx]);
                    if (res != null && res.exists() && !folders.contains(res)) {
                        folders.add(res);
                        res.getProject().refreshLocal(2, null);
                    }
                    ++idx;
                }
                folders.clear();
                this.fSelections = null;
                return;
            }
            catch (CoreException exc) {
                exc.printStackTrace();
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        try {
            ArrayList<IResource> folders = new ArrayList<IResource>();
            int idx = 0;
            while (idx < this.fSelections.length) {
                IResource res = HyadesUtil.getSelectionFolder((Object)this.fSelections[idx]);
                if (res != null && res.exists() && !folders.contains(res)) {
                    folders.add(res);
                    res.getProject().refreshLocal(2, null);
                }
                ++idx;
            }
            folders.clear();
            this.fSelections = null;
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
    }

    protected INavigator getViewer() {
        return this.fViewer;
    }

    public ISelection getSelection() {
        INavigator viewer = this.getViewer();
        ISelection sel = viewer.getViewer().getSelection();
        UniqueEList selObjects = new UniqueEList();
        if (sel != null && sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty()) {
            List selection = ((IStructuredSelection)sel).toList();
            Object item = null;
            int i = 0;
            while (i < selection.size()) {
                item = selection.get(i);
                if (item instanceof LogicalFolder) {
                    selObjects.addAll(((LogicalFolder)item).getChildren());
                } else {
                    selObjects.add(item);
                }
                ++i;
            }
            return new StructuredSelection((List)selObjects);
        }
        return sel;
    }

    public void run(IProgressMonitor monitor) {
        if (this.fSelections == null) {
            return;
        }
        SaveUtil.save(Arrays.asList(this.fSelections), monitor, this.fViewer.getID());
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fSelections = null;
    }
}

