/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.PlatformUI;

public class TraceHostUI
extends AbstractChangeable
implements SelectionListener {
    protected Button _edit;
    protected Button _delete;
    protected Button _add;
    protected Button _testConnection;
    protected Text _host;
    protected Text _port;
    protected Table _list;
    protected WizardPage _wizardPage = null;
    protected boolean enabledState = true;

    public TraceHostUI(WizardPage wp) {
        this.setWizardPage(wp);
    }

    public TraceHostUI() {
    }

    public void addHost() {
        HostDialog dialog = new HostDialog(CommonUITraceMessages.ADD_HST, null, null);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            StringBuffer buffer = new StringBuffer(dialog.getHost());
            buffer.append("[").append(dialog.getPort()).append("]");
            this.addHost(buffer.toString());
            this.enableButtons();
            this.changed();
            this.setHostText();
        }
    }

    public void editHost() {
        int exist = -1;
        HostDialog dialog = new HostDialog(CommonUITraceMessages.EDT_HST, this._host.getText(), this._port.getText());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            StringBuffer buffer = new StringBuffer(dialog.getHost());
            buffer.append("[").append(dialog.getPort()).append("]");
            int idx = 0;
            while (idx < this._list.getItemCount()) {
                if (buffer.toString().equals(this._list.getItem(idx).getText())) {
                    exist = idx;
                }
                ++idx;
            }
            if (exist > 0) {
                int index = this._list.getSelectionIndex();
                this._list.select(exist >= index ? index : exist);
            } else {
                this.editHost(buffer.toString());
            }
            this.enableButtons();
            this.changed();
            this.setHostText();
        }
    }

    public void addHost(String text) {
        if (text == null) {
            return;
        }
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (text.equals(this._list.getItem(idx).getText())) {
                this._list.select(idx);
                this.setHostText();
                return;
            }
            ++idx;
        }
        TableItem item = new TableItem(this._list, 0);
        item.setText(text.trim());
        item.setImage(CommonUITraceImages.INSTANCE.getImage("node_obj.gif"));
        this._list.setSelection(new TableItem[]{item});
        this.setHostText();
    }

    public void editHost(String text) {
        int i = this._list.getSelectionIndex();
        TableItem item = this._list.getItem(i);
        item.setText(text.trim());
        item.setImage(CommonUITraceImages.INSTANCE.getImage("node_obj.gif"));
    }

    protected void addHosts(String hosts) {
        if (hosts != null && hosts.length() > 0) {
            int idx = 0;
            while (idx != -1) {
                idx = hosts.indexOf(",");
                if (idx != -1) {
                    String host = hosts.substring(0, idx);
                    this.addHost(host);
                    hosts = hosts.substring(idx + 1);
                    continue;
                }
                this.addHost(hosts);
            }
        }
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        Label desc = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        desc.setLayoutData((Object)data);
        desc.setText(CommonUITraceMessages.PHNODE);
        Composite dataGroup = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        dataGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        dataGroup.setLayoutData((Object)data);
        this._list = new Table(dataGroup, 2304);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite bottomWidget = new Composite(dataGroup, 0);
        data = new GridData();
        bottomWidget.setLayoutData((Object)GridUtil.createHorizontalFill());
        layout = new GridLayout();
        layout.numColumns = 2;
        bottomWidget.setLayout((Layout)layout);
        Label hostLabel = new Label(bottomWidget, 0);
        hostLabel.setText(CommonUITraceMessages.PHIP);
        this._host = new Text(bottomWidget, 2048);
        this._host.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label portLabel = new Label(bottomWidget, 0);
        portLabel.setText(CommonUITraceMessages.RAC_PT);
        this._port = new Text(bottomWidget, 2048);
        this._port.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._port.setText(String.valueOf(10002));
        Composite buttonWidget = new Composite(result, 0);
        data = GridUtil.createVerticalFill();
        buttonWidget.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget.setLayout((Layout)layout);
        Composite buttonWidget1 = new Composite(buttonWidget, 0);
        data = GridUtil.createFill();
        buttonWidget1.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget1.setLayout((Layout)layout);
        this._edit = new Button(buttonWidget1, 0);
        this._edit.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._edit.setText(CommonUITraceMessages.PEDT);
        this._add = new Button(buttonWidget1, 0);
        this._add.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._add.setText(CommonUITraceMessages.PADD);
        this._delete = new Button(buttonWidget1, 0);
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._delete.setText(CommonUITraceMessages.RMV_TXT);
        this._testConnection = new Button(buttonWidget1, 0);
        this._testConnection.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._testConnection.setText(CommonUITraceMessages.TST_CON);
        Label l = new Label(buttonWidget1, 0);
        l.setLayoutData((Object)GridUtil.createVerticalFill());
        this._edit.addSelectionListener((SelectionListener)this);
        this._add.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._testConnection.addSelectionListener((SelectionListener)this);
        this._list.addSelectionListener((SelectionListener)this);
        this._host.setEditable(false);
        this._port.setEditable(false);
        this._delete.setEnabled(false);
        this._testConnection.setEnabled(false);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._list, "org.eclipse.tptp.platform.common.ui.trace.hstp0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._host, "org.eclipse.tptp.platform.common.ui.trace.hstp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._delete, "org.eclipse.tptp.platform.common.ui.trace.hstp0003");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._add, "org.eclipse.tptp.platform.common.ui.trace.hstp0004");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._testConnection, "org.eclipse.tptp.platform.common.ui.trace.hstp0005");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._port, "org.eclipse.tptp.platform.common.ui.trace.hstp0006");
        return result;
    }

    public Table getListUI() {
        return this._list;
    }

    public Text getHostUI() {
        return this._host;
    }

    public Text getPortUI() {
        return this._port;
    }

    public Button getDeleteUI() {
        return this._delete;
    }

    public Button getAddUI() {
        return this._add;
    }

    public WizardPage getWizardPage() {
        return this._wizardPage;
    }

    public void setWizardPage(WizardPage wp) {
        this._wizardPage = wp;
    }

    protected void deleteHost() {
        int i = this._list.getSelectionIndex();
        if (i != -1) {
            this._list.remove(i);
        }
        this._host.setText("");
        this._port.setText("");
        this.setDefaultHost();
    }

    protected void testConnection() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                TableItem tblItem;
                String hosts;
                int i = TraceHostUI.this._list.getSelectionIndex();
                if (i != -1 && (hosts = (tblItem = TraceHostUI.this._list.getItem(i)).getText()) != null && !hosts.equals("")) {
                    int idx = 0;
                    idx = hosts.lastIndexOf("[");
                    if (idx != -1) {
                        String host = hosts.substring(0, idx);
                        String port = hosts.substring(idx + 1, hosts.length() - 1);
                        HyadesUtil.testConnection((String)host, (String)port, (boolean)true, (Shell)TraceHostUI.this._list.getShell());
                    }
                }
            }
        });
    }

    public String getHost() {
        String name = null;
        int idx = this._list.getSelectionIndex();
        if (idx == -1) {
            return name;
        }
        name = this._list.getItem(idx).getText();
        int id = name.indexOf("[");
        if (id != -1) {
            name = name.substring(0, id);
        }
        return name;
    }

    public int getPort() {
        int id;
        String port = String.valueOf(10002);
        int idx = this._list.getSelectionIndex();
        if (idx != -1) {
            port = this._list.getItem(idx).getText();
        }
        port = (id = port.indexOf("[")) != -1 ? port.substring(id + 1, port.length() - 1) : String.valueOf(10002);
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public TableItem[] getHosts() {
        return this._list.getItems();
    }

    protected void initializeValues() {
        IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();
        String hosts = store.getString("use_host");
        String modifiedHosts = hosts;
        int indexOfIAC = modifiedHosts.indexOf("Local Direct Connection");
        if (indexOfIAC != -1) {
            int lengthOfIAC = "Local Direct Connection".length() + 1;
            modifiedHosts = modifiedHosts.substring(0, indexOfIAC);
            if (indexOfIAC + lengthOfIAC < hosts.length()) {
                modifiedHosts = String.valueOf(modifiedHosts) + hosts.substring(indexOfIAC + lengthOfIAC).trim();
            }
            if ((modifiedHosts = modifiedHosts.trim()).endsWith(",")) {
                modifiedHosts = modifiedHosts.substring(0, modifiedHosts.length() - 1);
            }
            hosts = modifiedHosts;
            store.setValue("use_host", modifiedHosts);
        }
        this.addHosts(hosts);
        this.setDefaultHost();
        this.setHostText();
        this.enableButtons();
    }

    public void reset() {
        this._list.removeAll();
    }

    public void setDefaultHost() {
        this._list.select(1);
        this.setHostText();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this._list && this._wizardPage != null && this._wizardPage.getNextPage() != null) {
            this._wizardPage.getWizard().getContainer().showPage(this._wizardPage.getNextPage());
        }
    }

    protected void enableButtons() {
        int idx = this._list.getSelectionIndex();
        String text = null;
        if (idx == -1) {
            this._edit.setEnabled(false);
            this._delete.setEnabled(false);
            this._testConnection.setEnabled(false);
            return;
        }
        text = this._list.getItem(this._list.getSelectionIndex()).getText();
        this._edit.setEnabled(this._list.getItemCount() > 1 && text != null);
        this._delete.setEnabled(this._list.getItemCount() > 1 && text != null && !text.equals("localhost[10002]"));
        this._testConnection.setEnabled(idx != -1);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._edit) {
            this.editHost();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        }
        if (e.widget == this._add) {
            this.addHost();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._delete) {
            this.deleteHost();
            this.enableButtons();
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._list) {
            this.enableButtons();
            this.setHostText();
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._testConnection) {
            this.testConnection();
            this.enableButtons();
            this._testConnection.setFocus();
        }
    }

    public void selectHost(String hostname) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (hostname.equals(this._list.getItem(idx).getText())) {
                this._list.setSelection(idx);
                this.enableButtons();
                return;
            }
            ++idx;
        }
        this.enableButtons();
    }

    public void setEnabled(boolean state) {
        this._list.setEnabled(state);
        this._add.setEnabled(state);
        this._delete.setEnabled(state);
        this._edit.setEnabled(state);
        this._port.setEnabled(state);
        this._testConnection.setEnabled(state);
        this._host.setEnabled(state);
        this.enabledState = state;
    }

    public boolean isEnabled() {
        return this.enabledState;
    }

    protected void setHostText() {
        TableItem[] selected = this._list.getSelection();
        if (selected.length > 0) {
            String text = selected[0].getText();
            int idx = text.lastIndexOf("[");
            if (idx != -1) {
                this._host.setText(text.substring(0, idx));
                if (idx < text.length() - 1) {
                    this._port.setText(text.substring(idx + 1, text.length() - 1));
                } else {
                    this._port.setText("");
                }
            }
        } else {
            this._host.setText("");
            this._port.setText("");
        }
    }

    class HostDialog
    extends Dialog
    implements ModifyListener {
        protected Text _host;
        protected Text _port;
        protected String hostStr;
        protected String portStr;
        protected String title;

        public HostDialog(String _title, String _hostStr, String _portStr) {
            super(Display.getCurrent().getActiveShell());
            this.title = _title;
            this.hostStr = _hostStr;
            this.portStr = _portStr;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(CommonUITraceMessages.PHIP);
            this._host = new Text(result, 2048);
            this._host.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._host.addModifyListener((ModifyListener)this);
            label = new Label(result, 0);
            label.setText(CommonUITraceMessages.RAC_PT);
            this._port = new Text(result, 2048);
            this._port.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._port.addModifyListener((ModifyListener)this);
            this._port.setText(this.portStr != null ? this.portStr : String.valueOf(10002));
            this._host.setText(this.hostStr != null ? this.hostStr : "localhost");
            this._host.setFocus();
            this._host.selectAll();
            this.enableField();
            return result;
        }

        protected void enableField() {
            if (this.title.equals(CommonUITraceMessages.EDT_HST)) {
                this._host.setEnabled(!this._host.getText().equals("localhost"));
            }
        }

        public void modifyText(ModifyEvent e) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._port.getText().trim().length() > 0 && this.isInteger(this._port.getText().trim()) && Integer.parseInt(this._port.getText().trim()) > 0 && this._host.getText().trim().length() > 0);
            }
        }

        public boolean isInteger(String input) {
            try {
                Integer.parseInt(input);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        protected void okPressed() {
            this.hostStr = this._host.getText().trim();
            this.portStr = this._port.getText().trim();
            super.okPressed();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getButton(0).setEnabled(this._port.getText().trim().length() > 0);
            return result;
        }

        public String getHost() {
            return this.hostStr;
        }

        public String getPort() {
            return this.portStr;
        }
    }
}

