/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.internal.execution.local.common.ExtendedDataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.loaders.util.BinaryLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.util.internal.InvalidEventException;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.tptp.platform.common.ui.trace.internal.util.PDCoreUtil;

public class XMLTraceDataProcessor
extends BinaryLoader
implements ExtendedDataServerListener {
    protected boolean newFile;
    protected static final String NEW_LINE = "\n";
    protected static final int BUFFER_SIZE = 65536;
    protected boolean firstEvent = true;
    protected OutputStream fileWriter = null;
    protected String profileFileName = null;
    protected final String START_TAG = "<TRACE>";
    protected final String END_TAG = "</TRACE>";
    protected final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    protected final String END_TAG_REPLACE = "\n<!-- new trace starts-->\n";
    protected final String START_TRACE = "<TRACE>\n";
    protected final String END_TRACE = "</TRACE>\n";
    protected final String XML_VERSION = "<?xml version=\"1.0\"?>\n";
    protected static final char[] ID1_IN = new char[]{'i', 'D', '1', '>'};
    protected static final char[] ID1_OUT = new char[]{'i', 'D', '1', '<'};
    protected static final char[] ID2_IN = new char[]{'i', 'D', '2', '>'};
    protected static final char[] ID2_OUT = new char[]{'i', 'D', '2', '<'};
    protected static final String INCOMMING_DATA = "incommingData";
    protected boolean specialProcessing = true;
    protected long totalBytesRead = 0L;
    protected long prevTotalBytesRead = 0L;
    protected long startTime;
    protected boolean validTag;
    protected int tempRemaining;

    public XMLTraceDataProcessor(TRCAgent agent) {
        super(agent);
        this.setCollectionMode(agent.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCAgentProxy agentProxy) {
        super(agentProxy);
        this.setCollectionMode(agentProxy.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCMonitor monitor) {
        super(monitor);
        new RefreshUI().start();
    }

    public void setWriter(OutputStream fw) {
        this.fileWriter = fw;
    }

    public OutputStream getWriter() {
        return this.fileWriter;
    }

    public void setProfileFileName(String profileFileName) {
        this.profileFileName = profileFileName;
    }

    public String getProfileFileName() {
        return this.profileFileName;
    }

    public void createWriter() {
        try {
            if (this.profileFileName != null) {
                this.fileWriter = this.makeWriter();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getDumpFileName() {
        return "TraceContents-" + this.getTimeStamp() + ".xml";
    }

    protected OutputStream makeWriter() throws IOException {
        File f = new File(this.profileFileName);
        if (f.exists()) {
            if (!PDCoreUtil.isZipFile(this.profileFileName)) {
                this.checkAndRemoveEndTag(this.profileFileName);
                this.newFile = false;
                return new BufferedOutputStream(new FileOutputStream(this.profileFileName, true), 65536);
            }
            File newFileName = new File(new StringBuffer(f.getParentFile().getAbsolutePath()).append(System.getProperty("file.separator")).append("Temp-").append(new Date().getTime()).toString());
            this.renameFile(f, newFileName);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f), 65536));
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(newFileName), 65536));
            try {
                this.copyZip(zipInputStream, zipOutputStream);
            }
            catch (Exception exception) {
                zipOutputStream.close();
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f), 65536));
            }
            zipInputStream.close();
            newFileName.delete();
            ZipEntry traceEntry = new ZipEntry(this.getDumpFileName());
            zipOutputStream.putNextEntry(traceEntry);
            this.newFile = true;
            return zipOutputStream;
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.profileFileName));
        ZipOutputStream zipStream = new ZipOutputStream(fos);
        ZipEntry traceEntry = new ZipEntry(this.getDumpFileName());
        zipStream.putNextEntry(traceEntry);
        this.newFile = true;
        return zipStream;
    }

    protected boolean renameFile(File f, File newFileName) {
        boolean ret = f.renameTo(newFileName);
        if (!ret) {
            ret = this.copyFile(f, newFileName);
            f.delete();
        }
        return ret;
    }

    protected boolean copyFile(File f, File newFileName) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(f), 65536);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(newFileName), 65536);
            byte[] buffer = new byte[65536];
            while (bufferedInputStream.available() > 0) {
                bufferedInputStream.read(buffer);
                bufferedOutputStream.write(buffer);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry;
        byte[] data = new byte[65536];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int byteCount;
            zipOutputStream.putNextEntry(zipEntry);
            while ((byteCount = zipInputStream.read(data, 0, 65536)) != -1) {
                zipOutputStream.write(data, 0, byteCount);
            }
            zipOutputStream.closeEntry();
        }
    }

    protected String getTimeStamp() {
        return DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date()).replace(' ', '_').replace(':', '_').replace(',', '_');
    }

    public void dataServerExited() {
        try {
            if (this.getAgentProxy() != null) {
                this.prevTotalBytesRead = this.totalBytesRead;
                this.getAgentProxy().setCollectionData(false);
                if (!this.getAgentProxy().eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_StopTime())) {
                    LoadersUtils.setSessionStopTime((double)System.currentTimeMillis(), (TRCAgentProxy)this.getAgentProxy());
                }
                this.endTrace(this.getWriter());
                this.setProfileFileName(null);
                this.setWriter(null);
                this.cleanUp();
                Display d = Display.getDefault();
                d.asyncExec(new Runnable(){

                    public void run() {
                        ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
                        event.setSource((Object)XMLTraceDataProcessor.this.getAgentProxy());
                        event.setType(1024);
                        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
                    }
                });
            }
        }
        catch (Exception exc) {
            ModelDebugger.log((Throwable)exc);
        }
    }

    public void dispose() {
        super.cleanUp();
        this.fileWriter = null;
    }

    public void endTrace(OutputStream randomFile) {
        try {
            if (randomFile != null) {
                randomFile.write("</TRACE>\n".getBytes());
                randomFile.flush();
                randomFile.close();
                randomFile = null;
            }
        }
        catch (IOException iOException) {}
    }

    protected boolean isValidTag(byte[] buf, int offset, int length) {
        if (this.validTag) {
            return true;
        }
        if (this.startsWith(buf, offset, length, "<TRACE>".getBytes()) || this.startsWith(buf, offset, length, "<?xml version=\"1.0\"?>".getBytes())) {
            return false;
        }
        this.validTag = true;
        return true;
    }

    protected boolean startsWith(byte[] container, int offset, int length, byte[] bytes) {
        if (length < bytes.length) {
            return false;
        }
        int i = 0;
        while (i < bytes.length) {
            if (container[offset + i] != bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void loadEventHook(byte[] buffer, int offset, int length) {
        if (this.firstEvent) {
            if (length > 1 && (buffer[offset] != 60 || buffer[offset + 1] != 63)) {
                LoadersUtils.loadRootEvent((XMLLoader)this);
            }
            this.firstEvent = false;
        }
        super.loadEvent(buffer, offset, length);
    }

    protected void loadEventHook(byte[] buffer, int length) {
        this.loadEventHook(buffer, 0, length);
    }

    public void incommingData(byte[] buffer, int offset, int length, InetAddress peer) {
        if (ModelDebugger.INSTANCE.debugEventValue) {
            ModelDebugger.INSTANCE.writeBinaryLog(INCOMMING_DATA, buffer, offset, length);
        }
        if (ModelDebugger.INSTANCE.debugEventFlow) {
            System.out.println(ID1_IN);
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.totalBytesRead += (long)length;
                if (this.isValidTag(buffer, offset, length)) {
                    this.writeByte(buffer, offset, length);
                }
            } else {
                this.loadEventHook(buffer, offset, length);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError e) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(ID1_OUT);
                System.out.println(" = " + e.getLocalizedMessage());
            }
            ModelDebugger.log((Throwable)e);
            throw e;
        }
        if (ModelDebugger.INSTANCE.debugEventFlow) {
            System.out.println(ID1_OUT);
        }
    }

    public void incommingData(char[] buffer, int offset, int length, InetAddress peer) {
        if (ModelDebugger.INSTANCE.debugEventFlow) {
            System.out.println(ID2_IN);
        }
        byte[] newBuffer = new byte[length];
        int i = 0;
        while (i < length) {
            newBuffer[i] = (byte)buffer[offset + i];
            ++i;
        }
        if (ModelDebugger.INSTANCE.debugEventValue) {
            ModelDebugger.INSTANCE.writeBinaryLog(INCOMMING_DATA, newBuffer, 0, length);
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.totalBytesRead += (long)length;
                if (this.isValidTag(newBuffer, 0, length)) {
                    this.writeByte(newBuffer, 0, length);
                }
            } else {
                this.loadEventHook(newBuffer, length);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError e) {
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(ID2_OUT);
                System.out.println(" = " + e.getLocalizedMessage());
            }
            this.handleOutOfMemoryError();
            this.stopAgent();
            ModelDebugger.log((Throwable)e);
            throw e;
        }
        System.out.println(ID2_OUT);
    }

    public void invalidDataType(byte[] data, int offset, int length, InetAddress peer) {
    }

    public void waitingForData() {
    }

    public void startTrace(OutputStream randomFile) {
        try {
            if (this.getAgentProxy() != null) {
                randomFile.write("<TRACE>\n".getBytes());
                randomFile.flush();
            }
        }
        catch (IOException iOException) {}
    }

    public void writeHeader(Writer randomFile) {
    }

    public void writeXMLVersion(OutputStream randomFile) {
        try {
            randomFile.write("<?xml version=\"1.0\"?>\n".getBytes());
            randomFile.flush();
        }
        catch (IOException iOException) {}
    }

    protected TRCAgentProxy getAgentProxy() {
        return this.getContext().getAgentProxy();
    }

    protected void handleOutOfMemoryError() {
        final Status err = new Status(2, "org.eclipse.core.resources", 566, CommonUITraceMessages.POUTMEM_ERRT, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)new Shell(), (String)CommonUITraceMessages.TRC_MSGT, (String)CommonUITraceMessages.OUTMEM_ERRT, (IStatus)err);
            }
        });
    }

    protected synchronized void notifyListener(Agent a, TRCAgentProxy agent) {
        final TRCAgentProxy ag = agent;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
                event.setSource((Object)ag);
                event.setType(2);
                TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
            }
        });
    }

    protected void stopAgent() {
        if (this.getAgentProxy() != null) {
            try {
                Agent ai = (Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy());
                if (ai != null) {
                    ai.stopMonitoring();
                }
            }
            catch (InactiveAgentException e) {
                e.printStackTrace();
            }
            this.getAgentProxy().setMonitored(false);
            this.getAgentProxy().setAttached(false);
            this.getAgentProxy().setActive(false);
            LoadersUtils.deregisterDataProcessor((TRCAgentProxy)this.getAgentProxy());
            if (this.fileWriter != null) {
                this.endTrace(this.fileWriter);
            }
            this.notifyListener((Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy()), this.getAgentProxy());
        }
    }

    protected void writeByte(byte[] data, int offset, int length) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(data, offset, length);
                this.fileWriter.write(NEW_LINE.getBytes());
                this.fileWriter.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isNewProfileFile() {
        return this.newFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAndRemoveEndTag(String filename) {
        File checkFile = new File(filename);
        if (!checkFile.exists()) return false;
        if (!checkFile.isFile()) return false;
        try {
            RandomAccessFile raf = new RandomAccessFile(checkFile, "rw");
            long checkFileSize = raf.length();
            StringBuffer b = new StringBuffer("</TRACE>");
            long seekLocation = checkFileSize - (long)b.length() - 2L;
            if (seekLocation < 0L) {
                seekLocation = 0L;
            }
            raf.seek(seekLocation);
            while (true) {
                if (seekLocation > checkFileSize) {
                    raf.close();
                    return false;
                }
                String readLine = raf.readLine();
                StringBuffer t = new StringBuffer(readLine);
                if (readLine.indexOf("</TRACE>") >= 0) {
                    raf.seek(seekLocation);
                    raf.writeBytes("\n<!-- new trace starts-->\n");
                    raf.close();
                    return true;
                }
                seekLocation += (long)t.length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void incommingData(byte[] data, int length, InetAddress peer) {
        this.incommingData(data, 0, length, peer);
    }

    public void incommingData(char[] data, int length, InetAddress peer) {
        this.incommingData(data, 0, length, peer);
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
        this.invalidDataType(data, 0, length, peer);
    }

    public void incommingStream(InputStream inputStream, InetAddress peer) {
        if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
            try {
                int readBytes = 0;
                this.totalBytesRead = 0L;
                this.prevTotalBytesRead = 0L;
                byte[] buffer = new byte[65536];
                while ((readBytes = inputStream.read(buffer)) != -1) {
                    this.totalBytesRead += (long)readBytes;
                    this.fileWriter.write(buffer, 0, readBytes);
                }
                this.fileWriter.flush();
                this.fileWriter.close();
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.common.ui.trace", 4, "", (Throwable)e);
                CommonPlugin.logError((IStatus)status);
            }
        } else {
            this.loadEvents(inputStream, 0, -1);
        }
        this.cleanUp();
    }

    public void loadEvents(InputStream inputStream, int offset, int length) throws InvalidEventException {
        if (this.scanner == null) {
            return;
        }
        final InputStream delegatedInputStream = inputStream;
        InputStream monitoredInputStream = new InputStream(){
            byte[] temp;
            byte[] oneByte = new byte[1];

            public synchronized int read(byte[] b, int off, int len) throws IOException {
                int readBytes = 0;
                if (XMLTraceDataProcessor.this.specialProcessing) {
                    if (XMLTraceDataProcessor.this.firstEvent) {
                        readBytes = delegatedInputStream.read(b, off, 2);
                        if (readBytes > 1 && b[off] == 60 && b[off + 1] != 63 || readBytes > 0 && b[off] != 60) {
                            this.temp = new byte[readBytes += "<TRACE>".getBytes().length];
                            System.arraycopy("<TRACE>".getBytes(), 0, this.temp, 0, "<TRACE>".getBytes().length);
                            this.temp[this.temp.length - 2] = b[off];
                            this.temp[this.temp.length - 1] = b[off + 1];
                            readBytes = Math.min(readBytes, len);
                            System.arraycopy(this.temp, 0, b, off, readBytes);
                            if ((len -= readBytes) > 0) {
                                readBytes += delegatedInputStream.read(b, off + readBytes, len);
                                XMLTraceDataProcessor.this.specialProcessing = false;
                                this.temp = null;
                            } else if (len < 0) {
                                XMLTraceDataProcessor.this.tempRemaining = this.temp.length - readBytes;
                            } else {
                                XMLTraceDataProcessor.this.specialProcessing = false;
                                this.temp = null;
                            }
                        } else {
                            readBytes = delegatedInputStream.read(b, off, len);
                            XMLTraceDataProcessor.this.specialProcessing = false;
                        }
                        XMLTraceDataProcessor.this.firstEvent = false;
                    } else {
                        readBytes = Math.min(XMLTraceDataProcessor.this.tempRemaining, len);
                        System.arraycopy(this.temp, 0, b, off, readBytes);
                        off += readBytes;
                        if ((len -= readBytes) > 0) {
                            readBytes += delegatedInputStream.read(b, off, len);
                        }
                        XMLTraceDataProcessor.this.tempRemaining -= readBytes;
                        if (XMLTraceDataProcessor.this.tempRemaining == 0) {
                            XMLTraceDataProcessor.this.specialProcessing = false;
                            this.temp = null;
                        }
                    }
                } else {
                    readBytes = delegatedInputStream.read(b, off, len);
                }
                XMLTraceDataProcessor.this.totalBytesRead += (long)readBytes;
                if (ModelDebugger.INSTANCE.debugEventValue) {
                    ModelDebugger.INSTANCE.writeBinaryLog(XMLTraceDataProcessor.INCOMMING_DATA, b, off, readBytes);
                }
                return readBytes;
            }

            public int available() throws IOException {
                return delegatedInputStream.available();
            }

            public void close() throws IOException {
                delegatedInputStream.close();
                XMLTraceDataProcessor.this.tempRemaining = -1;
            }

            public synchronized void mark(int readlimit) {
                delegatedInputStream.mark(readlimit);
            }

            public boolean markSupported() {
                return delegatedInputStream.markSupported();
            }

            public int read() throws IOException {
                if (this.read(this.oneByte, 0, 1) == -1) {
                    return -1;
                }
                return this.oneByte[0];
            }

            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public synchronized void reset() throws IOException {
                delegatedInputStream.reset();
            }

            public long skip(long n) throws IOException {
                return delegatedInputStream.skip(n);
            }
        };
        try {
            this.scanner.scanContent((InputStream)new BufferedInputStream(monitoredInputStream, 16384), (long)offset, (long)length);
        }
        catch (Throwable throwable) {
            if (this.tempRemaining != -1) {
                this.logLiveProgress(this.getProcessedFragments(), this.startTime, this.totalBytesRead);
            }
            return;
        }
        this.logLiveProgress(this.getProcessedFragments(), this.startTime, this.totalBytesRead);
    }

    public synchronized void cleanUp() {
        this.logLiveProgress(this.getProcessedFragments(), this.startTime, this.totalBytesRead);
        Display d = Display.getDefault();
        if (d == null || d.isDisposed()) {
            return;
        }
        if (this.getAgentProxy() != null && this.getAgentProxy().isCollectionData()) {
            this.getAgentProxy().setCollectionData(false);
        }
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
                event.setSource((Object)XMLTraceDataProcessor.this.getAgentProxy());
                event.setType(1024);
                TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
                if (ModelDebugger.INSTANCE.debug) {
                    ModelDebugger.log((String)"Live connection refresh thread - set STOP_COLLECTING ");
                }
            }
        });
        super.cleanUp();
    }

    private void logLiveProgress(int fragmentsProcessed, long startTime, long totalBytes) {
        if (ModelDebugger.INSTANCE.debug) {
            long deltaTime = (System.currentTimeMillis() - startTime) / 1000L;
            if (deltaTime == 0L) {
                deltaTime = 1L;
            }
            String status = MessageFormat.format((String)TraceWizardMessages.LIVE_PROGRESS, (Object[])new String[]{"" + this.getProcessedFragments(), "" + (long)this.getProcessedFragments() / deltaTime, "" + deltaTime, "" + this.totalBytesRead, "" + this.totalBytesRead / deltaTime});
            ModelDebugger.log((String)status);
        }
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
        if (toProfileFile) {
            this.totalBytesRead += (long)length;
        }
        super.loadEvent(buffer, offset, length, loadToModel, toProfileFile);
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel) throws InvalidXMLException {
        this.totalBytesRead += (long)length;
        super.loadEvent(buffer, offset, length, loadToModel);
    }

    class RefreshUI
    extends Thread {
        int collectingState;
        int prevProcessedFragments;
        long prevTime;
        long bpsLastReportedTime;
        long bpsLastReportedTotalBytes;
        int bpsLastBytesPerSecondTime;

        public RefreshUI() {
            super("Profile UI");
            this.prevProcessedFragments = 0;
            this.bpsLastReportedTime = 0L;
            this.bpsLastReportedTotalBytes = 0L;
            this.bpsLastBytesPerSecondTime = 0;
        }

        public void updateStatusBar() {
            Display d = Display.getDefault();
            if (d == null || d.isDisposed()) {
                return;
            }
            d.asyncExec(new Runnable(){
                protected long t;
                protected long t1;

                public void run() {
                    INavigator navigator = HyadesUtil.getActiveNavigator();
                    if (navigator == null) {
                        return;
                    }
                    if (HyadesUtil.getMofObject() != XMLTraceDataProcessor.this.getAgentProxy()) {
                        return;
                    }
                    this.t = System.currentTimeMillis();
                    this.t1 = (this.t - RefreshUI.this.prevTime) / 1000L;
                    RefreshUI.this.prevTime = this.t;
                    this.t = (this.t - ((RefreshUI)RefreshUI.this).XMLTraceDataProcessor.this.startTime) / 1000L;
                    if (this.t == 0L) {
                        this.t = 1L;
                    }
                    if (this.t1 == 0L) {
                        this.t1 = 1L;
                    }
                    int deltaEvents = XMLTraceDataProcessor.this.getProcessedFragments() - RefreshUI.this.prevProcessedFragments;
                    RefreshUI.this.prevProcessedFragments = XMLTraceDataProcessor.this.getProcessedFragments();
                    if (RefreshUI.this.bpsLastReportedTime == 0L) {
                        RefreshUI.this.bpsLastReportedTime = System.currentTimeMillis();
                    }
                    long reportedBytesDelta = ((RefreshUI)RefreshUI.this).XMLTraceDataProcessor.this.totalBytesRead - RefreshUI.this.bpsLastReportedTotalBytes;
                    long reportedTimeDelta = System.currentTimeMillis() - RefreshUI.this.bpsLastReportedTime;
                    int bytesPerSecondResult = 0;
                    if (reportedTimeDelta < 1000L) {
                        bytesPerSecondResult = RefreshUI.this.bpsLastBytesPerSecondTime;
                    } else {
                        RefreshUI.this.bpsLastReportedTotalBytes = ((RefreshUI)RefreshUI.this).XMLTraceDataProcessor.this.totalBytesRead;
                        RefreshUI.this.bpsLastReportedTime = System.currentTimeMillis();
                        RefreshUI.this.bpsLastBytesPerSecondTime = bytesPerSecondResult = (int)(1000.0 * (double)((float)reportedBytesDelta / (float)reportedTimeDelta));
                    }
                    String statusBarMessage = MessageFormat.format((String)TraceWizardMessages.LIVE_PROGRESS, (Object[])new String[]{"" + RefreshUI.this.prevProcessedFragments, "" + (long)deltaEvents / this.t1, "" + this.t, "" + ((RefreshUI)RefreshUI.this).XMLTraceDataProcessor.this.totalBytesRead, "" + bytesPerSecondResult});
                    IStatusLineManager statusLineManager = navigator.getViewSite().getActionBars().getStatusLineManager();
                    statusLineManager.setMessage(statusBarMessage);
                    if (ModelDebugger.INSTANCE.debug) {
                        ModelDebugger.log((String)"Live connection refresh thread - update status bar");
                    }
                }
            });
        }

        public void run() {
            Display d;
            this.prevTime = XMLTraceDataProcessor.this.startTime = System.currentTimeMillis();
            while (XMLTraceDataProcessor.this.scanner != null) {
                try {
                    this.updateStatusBar();
                    if (XMLTraceDataProcessor.this.getAgentProxy() != null) {
                        if (XMLTraceDataProcessor.this.prevTotalBytesRead == XMLTraceDataProcessor.this.totalBytesRead) {
                            if (this.collectingState != 1) {
                                if (XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                                    XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(false);
                                }
                                if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                    return;
                                }
                                d.asyncExec(new Runnable(){

                                    public void run() {
                                        ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
                                        event.setSource((Object)XMLTraceDataProcessor.this.getAgentProxy());
                                        event.setType(1024);
                                        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
                                        if (ModelDebugger.INSTANCE.debug) {
                                            ModelDebugger.log((String)"Live connection refresh thread - set STOP_COLLECTING ");
                                        }
                                    }
                                });
                                this.collectingState = 1;
                            }
                        } else if (XMLTraceDataProcessor.this.totalBytesRead > XMLTraceDataProcessor.this.prevTotalBytesRead && this.collectingState != 2) {
                            if (!XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                                XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(true);
                            }
                            if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                return;
                            }
                            d.asyncExec(new Runnable(){

                                public void run() {
                                    ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
                                    event.setSource((Object)XMLTraceDataProcessor.this.getAgentProxy());
                                    event.setType(512);
                                    TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
                                    if (ModelDebugger.INSTANCE.debug) {
                                        ModelDebugger.log((String)"Live connection refresh thread - set COLLECTING ");
                                    }
                                }
                            });
                            this.collectingState = 2;
                        }
                    }
                    XMLTraceDataProcessor.this.prevTotalBytesRead = XMLTraceDataProcessor.this.totalBytesRead;
                    RefreshUI.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (ModelDebugger.INSTANCE.debug) {
                ModelDebugger.log((String)"RefreshUI stopped");
            }
            if ((d = Display.getDefault()) != null && !d.isDisposed()) {
                d.syncExec(new Runnable(){

                    public void run() {
                        try {
                            INavigator navigator = HyadesUtil.getActiveNavigator();
                            if (navigator == null) {
                                return;
                            }
                            String statusBarMessage = "";
                            IStatusLineManager statusLineManager = navigator.getViewSite().getActionBars().getStatusLineManager();
                            statusLineManager.setMessage(statusBarMessage);
                        }
                        catch (Exception exception) {}
                    }
                });
            }
        }
    }
}

