/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.util.provisional.ITraceModelInteraction;
import org.eclipse.hyades.models.util.provisional.TraceModelInteraction;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;

public class DeleteUtil {
    protected static boolean isDeleteInProgress = false;

    public static void deleteAgent(TRCAgentProxy agent, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (agent == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        TRCProcessProxy process = agent.getProcessProxy();
        if (process == null) {
            return;
        }
        DeleteUtil.deleteExternalItems(agent, refresh, deleteContents, saveRequired, navigatorID);
        DeleteUtil.removeDoc(agent, deleteContents, saveRequired, navigatorID);
        agent.setProcessProxy(null);
        if (process.getAgentProxies().size() == 0) {
            DeleteUtil.deleteProcess(process, refresh, deleteContents, saveRequired, navigatorID);
        }
        if (refresh) {
            ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
            event.setSource(null);
            event.setType(64);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
    }

    public static void deleteEObject(EObject eObject, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (eObject instanceof TRCAgent) {
            DeleteUtil.deleteAgent(((TRCAgent)eObject).getAgentProxy(), refresh, deleteContents, saveRequired, navigatorID);
        } else if (eObject instanceof TRCProcessProxy) {
            DeleteUtil.deleteProcess((TRCProcessProxy)eObject, refresh, deleteContents, saveRequired, navigatorID);
        } else if (eObject instanceof TRCNode) {
            DeleteUtil.deleteNode((TRCNode)eObject, refresh, deleteContents, saveRequired, navigatorID);
        } else if (eObject instanceof TRCMonitor) {
            DeleteUtil.deleteMonitor((TRCMonitor)eObject, refresh, deleteContents, saveRequired, navigatorID);
        } else if (eObject instanceof CorrelationContainer) {
            DeleteUtil.deleteCorrelationContainer(((CorrelationContainer)eObject).getCorrelationContainerProxy(), refresh, deleteContents, saveRequired, navigatorID);
        }
    }

    public static void deleteProcess(TRCProcessProxy process, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (process == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        TRCNode node = process.getNode();
        if (node == null) {
            return;
        }
        if (node.getProcessProxies().size() == 1) {
            DeleteUtil.deleteNode(node, refresh, deleteContents, saveRequired, navigatorID);
        } else {
            DeleteUtil.removeDoc(process, deleteContents, saveRequired, navigatorID);
            DeleteUtil.deleteExternalItems(process, refresh, deleteContents, saveRequired, navigatorID);
            process.setNode(null);
        }
        if (refresh) {
            ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
    }

    public static void deleteMonitor(TRCMonitor monitor, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (monitor == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        for (TRCNode node : monitor.getNodes()) {
            for (TRCProcessProxy process : node.getProcessProxies()) {
                for (TRCAgentProxy agent : process.getAgentProxies()) {
                    DeleteUtil.deleteExternalItems(agent, refresh, deleteContents, saveRequired, navigatorID);
                }
                DeleteUtil.deleteExternalItems(process, refresh, deleteContents, saveRequired, navigatorID);
            }
            DeleteUtil.deleteExternalItems(node, refresh, deleteContents, saveRequired, navigatorID);
        }
        DeleteUtil.deleteExternalItems(monitor, refresh, deleteContents, saveRequired, navigatorID);
        Path path = new Path(TString.resourcePath((URI)monitor.eResource().getURI()));
        if (path.segmentCount() > 1) {
            path = path.removeLastSegments(1);
        }
        PDContentProvider.removeMonitor(path.toOSString(), monitor);
        DeleteUtil.removeDoc(monitor, deleteContents, saveRequired, navigatorID);
        if (refresh) {
            ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
    }

    public static void deleteNode(TRCNode node, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (node == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        TRCMonitor monitor = node.getMonitor();
        if (monitor == null) {
            return;
        }
        if (monitor.getNodes().size() == 1) {
            DeleteUtil.deleteMonitor(monitor, refresh, deleteContents, saveRequired, navigatorID);
        } else {
            DeleteUtil.removeDoc(node, deleteContents, saveRequired, navigatorID);
            DeleteUtil.deleteExternalItems(node, refresh, deleteContents, saveRequired, navigatorID);
            node.setMonitor(null);
        }
        if (refresh) {
            ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
    }

    public static void deleteContainer(IContainer container, boolean deleteContents, boolean saveRequired, String navigatorID) throws CoreException {
        if (container == null || !container.exists() || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        IResource[] members = container.members();
        if (members.length > 0) {
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFolder) {
                    IFolder member = (IFolder)members[i];
                    DeleteUtil.deleteContainer((IContainer)member, deleteContents, saveRequired, navigatorID);
                }
                ++i;
            }
        }
        ArrayList monitors = PDContentProvider.getMonitors(container);
        int idx = 0;
        while (idx < monitors.size()) {
            TRCMonitor mon;
            if (monitors.get(idx) instanceof TRCMonitor && (mon = (TRCMonitor)monitors.get(idx)) != null) {
                DeleteUtil.deleteMonitor(mon, true, deleteContents, saveRequired, navigatorID);
            }
            ++idx;
        }
        DeleteUtil.deleteExternalItems(container, true, deleteContents, saveRequired, navigatorID);
        PDContentProvider.removeContainer(container);
        container.delete(true, null);
    }

    public static void deleteResource(IResource resource, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (resource == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        try {
            if (resource == null || !resource.exists()) {
                return;
            }
            if (resource instanceof IProject || resource instanceof IFolder) {
                DeleteUtil.deleteContainer((IContainer)resource, deleteContents, saveRequired, navigatorID);
            } else {
                resource.delete(true, null);
            }
            ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
    }

    public static void deleteExternalItems(Object parent, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        INavigatorContribution[] delegates = NavigatorExtensionUtil.getContributions((String)navigatorID);
        int i = 0;
        while (i < delegates.length) {
            List children = delegates[i].getChildren(parent);
            for (INavigatorItem item : children) {
                if (!item.isDeleteEnabled()) continue;
                item.delete(refresh, deleteContents);
            }
            ++i;
        }
    }

    public static void removeDoc(TRCAgentProxy agent, boolean deleteContents, boolean saveRequired, String navigatorID) {
        ITraceModelInteraction[] contributors;
        if (agent == null || agent.getAgent() == null || agent.getAgent().eResource() == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        TraceUIManager.getTraceUIManager().removeSelectionModel((EObject)agent);
        LoadersUtils.deregisterDataProcessor((TRCAgentProxy)agent);
        LoadersUtils.deregisterAgentListener((TRCAgentProxy)agent);
        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)agent);
        LoadersUtils.deregisterAgentProxyContext((TRCAgentProxy)agent);
        if (deleteContents) {
            Path path = new Path(TString.resourcePath((URI)agent.getAgent().eResource().getURI()));
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true, saveRequired, navigatorID);
        }
        if ((contributors = TraceModelInteraction.getContributors()) != null && contributors.length > 0) {
            int contributor = 0;
            while (contributor < contributors.length) {
                contributors[contributor].traceModelDelete(agent.eResource(), deleteContents);
                ++contributor;
            }
        }
        ArrayList list = TraceUIManager.getTraceUIManager().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister((Object)agent);
            ++idx;
        }
        TRCProcessProxy process = agent.getProcessProxy();
        TRCNode trcnode = process.getNode();
        if (process == null || trcnode == null) {
            return;
        }
        try {
            Agent a;
            Object instance;
            String nodeName = trcnode.getName();
            Node node = NodeFactory.createNode((String)nodeName);
            if (node.isConnected() && (instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent)) != null && instance instanceof Agent && (a = (Agent)instance).isAttached()) {
                a.detach();
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        DeleteUtil.unloadDoc((EObject)agent.getAgent());
        for (Resource res : EMFUtil.delete((EObject)agent, (ResourceSet)agent.eResource().getResourceSet())) {
            if (res == null) continue;
            res.setModified(true);
            if (!res.getURI().toString().endsWith("trcmxmi")) continue;
            try {
                DeleteUtil.cleanupEmptyCorrelationContainersProxies((TRCMonitor)res.getContents().get(0), deleteContents, saveRequired, navigatorID);
            }
            catch (Exception exception) {}
        }
    }

    protected static void cleanupEmptyCorrelationContainersProxies(TRCMonitor monitor, boolean deleteContents, boolean saveRequired, String navigatorID) {
        CorrelationContainerProxy[] containerProxies = (CorrelationContainerProxy[])monitor.getCorrelationContainerProxies().toArray();
        int i = 0;
        while (i < containerProxies.length) {
            if (containerProxies[i].getCorrelatedAgents().isEmpty()) {
                DeleteUtil.deleteCorrelationContainer(containerProxies[i], true, deleteContents, saveRequired, navigatorID);
            }
            ++i;
        }
    }

    public static void removeDoc(TRCMonitor mon, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (mon == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        ArrayList list = TraceUIManager.getTraceUIManager().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister((Object)mon);
            ++idx;
        }
        if (mon.eResource() != null && deleteContents) {
            Path path = new Path(TString.resourcePath((URI)mon.eResource().getURI()));
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true, saveRequired, navigatorID);
        }
        Object[] nodes = mon.getNodes().toArray();
        int idx2 = 0;
        while (idx2 < nodes.length) {
            TRCNode node = (TRCNode)nodes[idx2];
            if (!node.eIsProxy()) {
                DeleteUtil.removeDoc(node, deleteContents, saveRequired, navigatorID);
            }
            ++idx2;
        }
        DeleteUtil.unloadDoc((EObject)mon);
    }

    public static void removeDoc(TRCNode node, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (node == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        ArrayList list = TraceUIManager.getTraceUIManager().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister((Object)node);
            ++idx;
        }
        if (node.eResource() != null && deleteContents) {
            Path path = new Path(TString.resourcePath((URI)node.eResource().getURI()));
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true, saveRequired, navigatorID);
        }
        Object[] processes = node.getProcessProxies().toArray();
        int idx2 = 0;
        while (idx2 < processes.length) {
            TRCProcessProxy process = (TRCProcessProxy)processes[idx2];
            if (!process.eIsProxy()) {
                DeleteUtil.removeDoc(process, deleteContents, saveRequired, navigatorID);
            }
            ++idx2;
        }
        TRCMonitor monitor = node.getMonitor();
        if (monitor == null) {
            return;
        }
        monitor.getNodes().remove((Object)node);
        if (saveRequired) {
            Path path = new Path(TString.resourcePath((URI)monitor.eResource().getURI()));
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null) {
                try {
                    SaveUtil.saveResource(null, (Resource)monitor.eResource());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        DeleteUtil.unloadDoc((EObject)node);
    }

    public static void removeDoc(TRCProcessProxy process, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (process == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        if (deleteContents) {
            Path path = new Path(TString.resourcePath((URI)process.eResource().getURI()));
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true, saveRequired, navigatorID);
        }
        Object[] agents = process.getAgentProxies().toArray();
        int idx = 0;
        while (idx < agents.length) {
            TRCAgentProxy agent = (TRCAgentProxy)agents[idx];
            if (!agent.eIsProxy()) {
                DeleteUtil.removeDoc(agent, deleteContents, saveRequired, navigatorID);
            }
            ++idx;
        }
        TRCNode node = process.getNode();
        if (node != null) {
            node.getProcessProxies().remove((Object)process);
            if (saveRequired) {
                Path path = new Path(TString.resourcePath((URI)node.eResource().getURI()));
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (res != null) {
                    try {
                        SaveUtil.saveResource(null, (Resource)node.eResource());
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }
        ArrayList list = TraceUIManager.getTraceUIManager().getDeleteListeners();
        int idx2 = 0;
        while (idx2 < list.size()) {
            ((IDeleteListener)list.get(idx2)).deregister((Object)process);
            ++idx2;
        }
        DeleteUtil.unloadDoc((EObject)process);
    }

    public static void unloadDoc(EObject object) {
        if (object == null || object.eResource() == null) {
            return;
        }
        TraceUIManager.getTraceUIManager().removeSelectionModel(object);
        ((IHyadesExtendedResource)object.eResource()).delete();
    }

    public static void deleteCorrelationContainer(CorrelationContainerProxy correlationContainerProxy, boolean refresh, boolean deleteContents, boolean saveRequired, String navigatorID) {
        if (correlationContainerProxy == null || navigatorID == null || navigatorID.trim().length() == 0) {
            return;
        }
        ArrayList list = TraceUIManager.getTraceUIManager().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister((Object)correlationContainerProxy);
            ++idx;
        }
        CorrelationContainer correlationContainer = correlationContainerProxy.getCorrelationContainer();
        if (correlationContainer != null && !correlationContainer.eIsProxy()) {
            IHyadesExtendedResource corrRes;
            if (deleteContents) {
                Path path = new Path(TString.resourcePath((URI)correlationContainer.eResource().getURI()));
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                DeleteUtil.deleteResource(res, true, saveRequired, navigatorID);
            }
            if ((corrRes = (IHyadesExtendedResource)correlationContainer.eResource()) != null) {
                corrRes.delete();
            }
            correlationContainer.setCorrelationContainerProxy(null);
        }
        if (correlationContainerProxy.getMonitor() != null) {
            Resource res = correlationContainerProxy.getMonitor().eResource();
            correlationContainerProxy.setMonitor(null);
            if (res != null && saveRequired) {
                try {
                    SaveUtil.saveResource(null, (Resource)res);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        for (TRCAgentProxy element : correlationContainerProxy.getCorrelatedAgents()) {
            if (!element.getInternalCorrelations().contains((Object)correlationContainerProxy)) continue;
            element.getInternalCorrelations().remove((Object)correlationContainerProxy);
        }
        correlationContainerProxy.getCorrelatedAgents().clear();
        if (refresh) {
            ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        }
    }

    public static void setDeleteInProgress(boolean newValue) {
        isDeleteInProgress = newValue;
    }

    public static boolean isDeleteInProgress() {
        return isDeleteInProgress;
    }
}

