/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CommonUITracePlugin
extends AbstractUIPlugin
implements Application {
    public static final String PLUGIN_ID = "org.eclipse.tptp.platform.common.ui.trace";
    protected static CommonUITracePlugin plugin;

    public CommonUITracePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ImageManager.initializeImages((ImageManager)CommonUITraceImages.INSTANCE, (AbstractUIPlugin)this);
        this.updateHostPreference();
    }

    protected void updateHostPreference() {
        IPreferenceStore store = this.getPreferenceStore();
        String hostList = store.getString("use_host");
        if (hostList.equals("localhost[10002]") || store.getBoolean("HOSTPREF_UPDATED")) {
            store.setValue("HOSTPREF_UPDATED", true);
            return;
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(hostList, ",");
        while (tokens.hasMoreElements()) {
            String hostPort = (String)tokens.nextElement();
            int idx = hostPort.lastIndexOf(":");
            if (idx > 0) {
                buff.append(hostPort.substring(0, idx)).append("[").append(hostPort.subSequence(idx + 1, hostPort.length())).append("]");
            } else {
                buff.append(hostPort);
            }
            buff.append(",");
        }
        String newPrefValue = buff.toString();
        store.setValue("use_host", newPrefValue.substring(0, newPrefValue.length() - 1));
        store.setValue("HOSTPREF_UPDATED", true);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CommonUITracePlugin getDefault() {
        return plugin;
    }

    public String getName() {
        return PLUGIN_ID;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("use_host", "localhost[10002]");
        store.setDefault("prj_name", CommonUITraceMessages.TRC_LOCD);
        store.setDefault("mon_name", CommonUITraceMessages.TRC_MONT);
        store.setDefault("lprj_name", "LogAnalyzerProject");
        store.setDefault("lmon_name", "DefaultMonitor");
        store.setDefault("save_on_exit", "prompt");
    }

    public void log(Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage(), e));
    }
}

