/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal.actions;

import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.actions.AbstractProfileActionDelegate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractListenerActionDelegate
extends AbstractProfileActionDelegate
implements IProfileEventListener,
IPartListener,
IPageListener {
    protected IWorkbenchWindow fWindow;

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void dispose() {
        TraceUIManager.getTraceUIManager().removeProfileEventListener((IProfileEventListener)this);
        if (this.getWindow() != null) {
            this.getWindow().removePageListener((IPageListener)this);
        }
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
        this.fWindow = null;
        super.dispose();
    }

    public void handleProfileEvent(final ProfileEvent event) {
        if (this.getPage() == null || this.getAction() == null) {
            return;
        }
        final Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                AbstractListenerActionDelegate.this.doHandleProfileEvent(event);
            }
        };
        this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(r);
    }

    protected IWorkbenchPage getPage() {
        if (this.getWindow() != null) {
            return this.getWindow().getActivePage();
        }
        return null;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected void doHandleProfileEvent(ProfileEvent event) {
        switch (event.getType()) {
            case 16: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 4: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 8: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 1: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 2: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 4096: {
                this.update(this.getAction(), (ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        TraceUIManager.getTraceUIManager().addProfileEventListener((IProfileEventListener)this);
        this.setWindow(window);
        window.addPageListener((IPageListener)this);
    }

    public void init(IViewPart view) {
        super.init(view);
        TraceUIManager.getTraceUIManager().addProfileEventListener((IProfileEventListener)this);
        this.setWindow(view.getViewSite().getWorkbenchWindow());
        view.getViewSite().getPage().addPartListener((IPartListener)this);
        view.getViewSite().getPage().getWorkbenchWindow().addPageListener((IPageListener)this);
    }

    public void pageActivated(final IWorkbenchPage page) {
        if (this.getPage() != null && this.getPage().equals(page)) {
            Runnable r = new Runnable(){

                public void run() {
                    IWorkbenchWindow window;
                    if (AbstractListenerActionDelegate.this.getPage() != null && (window = AbstractListenerActionDelegate.this.getPage().getWorkbenchWindow()) != null && window.getShell() != null && !window.getShell().isDisposed()) {
                        ISelection selection = page.getSelection("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                        AbstractListenerActionDelegate.this.update(AbstractListenerActionDelegate.this.getAction(), selection);
                    }
                }
            };
            this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(r);
        }
    }

    public void pageClosed(IWorkbenchPage page) {
        if (page.equals(this.getPage())) {
            this.dispose();
        }
    }

    public void pageOpened(IWorkbenchPage page) {
    }
}

