/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class RefreshFromLocalAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    protected INavigator fViewer;

    public RefreshFromLocalAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), CommonUITraceMessages.U_MEM);
        this.setDescription(Action.removeMnemonics((String)CommonUITraceMessages.U_MEM));
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.tptp.platform.common.ui.trace.refl0000");
        this.setToolTipText(Action.removeMnemonics((String)CommonUITraceMessages.U_MEM));
    }

    public void run() {
        List list;
        String preferenceKey = CommonUITracePlugin.getDefault().getPreferenceStore().getString("reload_no_question");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        boolean saveAndChange = false;
        if (CommonUITracePlugin.getDefault().getPreferenceStore().getBoolean("reload_no_question")) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)CommonUITraceMessages.TRC_MSGT, (String)CommonUITraceMessages.REL_INF, (String)CommonUITraceMessages.AT_MSGCB, (boolean)false, (IPreferenceStore)CommonUITracePlugin.getDefault().getPreferenceStore(), (String)preferenceKey);
            boolean bl = saveAndChange = dialog.getReturnCode() == 0;
            if (dialog.getToggleState()) {
                CommonUITracePlugin.getDefault().getPreferenceStore().setValue("reload_no_question", Boolean.toString(!saveAndChange));
            }
            if (shell.getMinimized()) {
                shell.setMinimized(false);
            }
            if (!saveAndChange) {
                return;
            }
        }
        if (!(list = this.getModifiedProcesses()).isEmpty()) {
            final Object[] listArray = list.toArray();
            IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    return listArray;
                }
            };
            ListSelectionDialog dlg = new ListSelectionDialog(Display.getCurrent().getActiveShell(), (Object)listArray, contentProvider, new SimpleLayout(null).getLabelProvider(), CommonUITraceMessages.FREE_MEM);
            dlg.setInitialSelections(listArray);
            dlg.setTitle(CommonUITraceMessages.TRC_MSGT);
            int result = dlg.open();
            if (result == 1) {
                return;
            }
            Object[] selections = dlg.getResult();
            if (listArray.length != selections.length && !MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)CommonUITraceMessages.TRC_MSGT, (String)CommonUITraceMessages.FREE_MEM1)) {
                return;
            }
            try {
                SaveAction saveAction = new SaveAction(this.fViewer);
                saveAction.finishSaving(selections);
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
        this.handleResources();
        this.fViewer.getViewer().refresh();
    }

    public boolean areLoadedResources() {
        for (Resource element : HierarchyResourceSetImpl.getInstance().getResources()) {
            if (!element.isLoaded() || element.getContents().size() <= 0 || !(element.getContents().get(0) instanceof TRCAgent)) continue;
            return true;
        }
        return false;
    }

    protected List getModifiedProcesses() {
        ArrayList<TRCProcessProxy> list = new ArrayList<TRCProcessProxy>();
        for (Resource element : HierarchyResourceSetImpl.getInstance().getResources()) {
            if (!element.isLoaded() || element.getContents().size() <= 0 || !(element.getContents().get(0) instanceof TRCAgent) || !element.isModified()) continue;
            TRCAgent agent = (TRCAgent)element.getContents().get(0);
            try {
                if (list.contains(agent.getAgentProxy().getProcessProxy())) continue;
                list.add(agent.getAgentProxy().getProcessProxy());
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled());
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }

    protected void handleResources() {
        Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
        int idx = 0;
        while (idx < resources.length) {
            Resource element = (Resource)resources[idx];
            if (element != null && element.isLoaded()) {
                Object[] elements = element.getContents().toArray();
                int i = 0;
                while (i < elements.length) {
                    Object obj = elements[i];
                    ArrayList deletelist = TraceUIManager.getTraceUIManager().getDeleteListeners();
                    int j = 0;
                    while (j < deletelist.size()) {
                        ((IDeleteListener)deletelist.get(j)).deregister(obj);
                        ++j;
                    }
                    if (obj instanceof TRCAgent) {
                        element.unload();
                    }
                    ++i;
                }
            }
            ++idx;
        }
    }
}

