/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RefreshTreeAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    protected INavigator fViewer;
    protected boolean refreshContents;

    public boolean getRefreshContents() {
        return this.refreshContents;
    }

    public RefreshTreeAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), CommonUITraceMessages.REFRESH);
        this.setDescription(CommonUITraceMessages.RTREE);
        CommonUIImages.setActionImage((ImageManager)CommonUITraceImages.INSTANCE, (IAction)this, (String)"refresh.gif");
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.tptp.platform.common.ui.trace.refr0000");
        this.setToolTipText(CommonUITraceMessages.RTREET);
    }

    public void run() {
        RefreshResourceDialog dlg = new RefreshResourceDialog(this.fViewer.getViewSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        this.refreshContents = dlg.getRefreshContent();
        if (this.refreshContents) {
            PDContentProvider.resetMonitors();
            Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
            int idx = 0;
            while (idx < resources.length) {
                Resource element = (Resource)resources[idx];
                if (element != null && element.isLoaded()) {
                    Object[] elements = element.getContents().toArray();
                    int i = 0;
                    while (i < elements.length) {
                        Object obj = elements[i];
                        ArrayList deletelist = TraceUIManager.getTraceUIManager().getDeleteListeners();
                        int j = 0;
                        while (j < deletelist.size()) {
                            ((IDeleteListener)deletelist.get(j)).deregister(obj);
                            ++j;
                        }
                        element.unload();
                        ++i;
                    }
                }
                ++idx;
            }
            if (this.fViewer.getID() != null && this.fViewer.getID().equals("org.eclipse.hyades.log.ui.logNavigator")) {
                ProfileEvent event = new ProfileEvent();
                event.setSource((Object)ResourcesPlugin.getWorkspace().getRoot());
                event.setType(4608);
                TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
            } else {
                this.fViewer.getViewer().refresh();
            }
        } else {
            this.fViewer.getViewer().refresh();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }

    public class RefreshResourceDialog
    extends MessageDialog {
        protected boolean refreshContent;
        protected Button radio1;
        protected Button radio2;
        static final String CONTINUE_LABEL = "&Continue";
        protected SelectionListener selectionListener;

        public RefreshResourceDialog(Shell parentShell) {
            super(parentShell, CommonUITraceMessages.TRC_MSGT, null, CommonUITraceMessages.CRTREE, 3, new String[]{CONTINUE_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.refreshContent = false;
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.widget;
                    if (button.getSelection()) {
                        RefreshResourceDialog.this.refreshContent = button == RefreshResourceDialog.this.radio1;
                    }
                }
            };
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = CommonUITraceMessages.RTREE_SYS;
            this.radio1.setText(text1);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = CommonUITraceMessages.RTREE_RES;
            this.radio2.setText(text2);
            new Label(composite, 0);
            Label messageLbl = new Label(composite, 64);
            messageLbl.setText(CommonUITraceMessages.REFRESH_WARNING);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLbl);
            this.radio1.setSelection(this.refreshContent);
            this.radio2.setSelection(!this.refreshContent);
            return composite;
        }

        public boolean getRefreshContent() {
            return this.refreshContent;
        }
    }
}

