/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal.actions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.ImportActionGroup;
import org.eclipse.hyades.trace.ui.internal.actions.OpenTraceReportAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.actions.ToggleLinkingAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.actions.RefreshFromLocalAction;
import org.eclipse.tptp.platform.common.ui.trace.internal.actions.RefreshTreeAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class TraceLogActionGroup
extends NavigatorActionGroup {
    protected DeleteAction fDeleteAction;
    protected SaveAction fSaveToFile;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected RefreshTreeAction fRefreshTree;
    protected RefreshFromLocalAction fRefreshLocal;
    protected Separator fRefreshGrp;
    protected ActionGroup fImportActionGroup;
    protected OpenTraceReportAction openReportAction;
    protected OpenWizardAction fOpenNodeAction;
    protected Separator fAttachGrp;
    protected Separator fMonitorGrp;
    protected Separator fTerminateGrp;
    protected Separator fNewSnapshotGrp;
    protected Separator fGCGroup;
    protected final String GROUP_ADD_VIEWS = "group.add.views";
    protected Map traceViewsMap;

    public TraceLogActionGroup(INavigator viewer) {
        super(viewer);
    }

    protected void createActions() {
        super.createActions();
        this.traceViewsMap = new HashMap();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), CommonUITraceMessages.LNKV);
        this.toggleLinkingAction.setToolTipText(CommonUITraceMessages.LNKVT);
        CommonUIImages.setActionImage((ImageManager)CommonUIImages.INSTANCE, (IAction)this.toggleLinkingAction, (String)"synced.gif");
        this.collapseAllAction = new CollapseAllAction((TreeViewer)this.getNavigator().getViewer());
        this.collapseAllAction.useDefaultDecorators();
        this.fImportActionGroup = new ImportActionGroup(this.getNavigator());
        this.fNewSnapshotGrp = new Separator("newSnapshotGroup");
        this.fGCGroup = new Separator("gcGroup");
        this.fRefreshGrp = new Separator("refreshGroup");
        this.fAttachGrp = new Separator("attachGroup");
        this.fTerminateGrp = new Separator("terminateGroup");
        this.fRefreshTree = new RefreshTreeAction(this.getNavigator());
        this.fMonitorGrp = new Separator("monitoringGroup");
        this.fSaveToFile = new SaveAction(this.getNavigator());
        this.fRefreshLocal = new RefreshFromLocalAction(this.getNavigator());
        this.fDeleteAction = new DeleteAction(this.getNavigator());
        this.openReportAction = new OpenTraceReportAction();
        this.fOpenNodeAction = new OpenWizardAction(this.getNavigator(), OpenNodeWizard.class, CommonUITraceMessages.PROP);
    }

    public void dispose() {
        if (this.traceViewsMap != null) {
            this.traceViewsMap.clear();
            this.traceViewsMap = null;
        }
        if (this.fImportActionGroup != null) {
            this.fImportActionGroup.dispose();
            this.fImportActionGroup = null;
        }
        this.deleteSeparators();
        this.deleteActions();
        super.dispose();
    }

    protected void deleteSeparators() {
        if (this.fAttachGrp != null) {
            this.fAttachGrp.dispose();
            this.fAttachGrp = null;
        }
        if (this.fRefreshGrp != null) {
            this.fRefreshGrp.dispose();
            this.fRefreshGrp = null;
        }
        if (this.fTerminateGrp != null) {
            this.fTerminateGrp.dispose();
            this.fTerminateGrp = null;
        }
        if (this.fMonitorGrp != null) {
            this.fMonitorGrp.dispose();
            this.fMonitorGrp = null;
        }
        if (this.fNewSnapshotGrp != null) {
            this.fNewSnapshotGrp.dispose();
            this.fNewSnapshotGrp = null;
        }
        if (this.fGCGroup != null) {
            this.fGCGroup.dispose();
            this.fGCGroup = null;
        }
    }

    protected void deleteActions() {
        if (this.fSaveToFile != null) {
            this.fSaveToFile.dispose();
            this.fSaveToFile = null;
        }
        if (this.fDeleteAction != null) {
            this.fDeleteAction.dispose();
            this.fDeleteAction = null;
        }
        if (this.fRefreshLocal != null) {
            this.fRefreshLocal.dispose();
            this.fRefreshLocal = null;
        }
        if (this.fRefreshTree != null) {
            this.fRefreshTree.dispose();
            this.fRefreshTree = null;
        }
        if (this.toggleLinkingAction != null) {
            this.toggleLinkingAction.dispose();
            this.toggleLinkingAction = null;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.toggleLinkingAction);
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IContributionItem)new Separator("monitoringGroup"));
        toolbar.add((IContributionItem)new Separator("gcGroup"));
        toolbar.add((IContributionItem)new Separator("refreshGroup"));
        toolbar.add((IContributionItem)new Separator("navigatorGroup"));
        toolbar.add((IAction)this.collapseAllAction);
        toolbar.add((IAction)this.toggleLinkingAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    public void fillContextMenuWithGroups(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    protected boolean areSameClass(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return true;
        }
        Class<?> objClass = selection.getFirstElement().getClass();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (objClass.equals(iterator.next().getClass())) continue;
            return false;
        }
        return true;
    }

    protected void updateActions(IStructuredSelection selection) {
        boolean saveEnabled = true;
        boolean deleteEnabled = true;
        if (selection.size() == 0) {
            deleteEnabled = false;
            saveEnabled = false;
        }
        for (Object next : selection) {
            if (!(next instanceof INavigatorItem)) continue;
            INavigatorItem item = (INavigatorItem)next;
            if (!item.isSaveEnabled()) {
                saveEnabled = false;
            }
            if (item.isDeleteEnabled()) continue;
            deleteEnabled = false;
        }
        this.fSaveToFile.setEnabled(saveEnabled);
        this.fDeleteAction.setEnabled(deleteEnabled);
        this.fRefreshLocal.setEnabled(this.fRefreshLocal.areLoadedResources());
    }

    protected IAction[] getViewMappingForType(String type) {
        IAction[] actions = (IAction[])this.getViewMappingForTypeUnsorted(type).clone();
        Arrays.sort(actions, new Comparator(){

            public int compare(Object o1, Object o2) {
                IAction a = (IAction)o1;
                IAction b = (IAction)o2;
                if (a != null && b != null) {
                    return a.getText().compareTo(b.getText());
                }
                return 0;
            }
        });
        return actions;
    }

    protected IAction[] getViewMappingForTypeUnsorted(String type) {
        Object mapp = this.traceViewsMap.get(type);
        if (mapp != null) {
            return (IAction[])mapp;
        }
        IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping mapping = registry.getAssociationMapping("analyzerExtensions");
        if (mapping == null) {
            IAction[] actions = new IAction[]{};
            this.traceViewsMap.put(type, actions);
            return actions;
        }
        IAssociationDescriptor[] array = mapping.getAssociationDescriptors(type);
        IAction[] actions = new IAction[array.length];
        int idx = 0;
        while (idx < array.length) {
            IAssociationDescriptor desc = array[idx];
            try {
                IAction action = (IAction)desc.createImplementationClassInstance();
                if (action != null) {
                    action.setText(desc.getName());
                    action.setImageDescriptor(desc.getImageDescriptor());
                    actions[idx] = action;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++idx;
        }
        this.traceViewsMap.put(type, actions);
        return actions;
    }

    public void propertyChanged(Object source, int propId) {
        if (source instanceof IAssociationMappingRegistry) {
            this.traceViewsMap.clear();
        }
    }

    public void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object obj = s.getFirstElement();
        if (obj == null || !(obj instanceof EObject) && !(obj instanceof INavigatorItem)) {
            return;
        }
        IAction action = this.getDefaultAction(obj);
        if (action != null) {
            action.run();
        }
    }

    protected IAction getDefaultAction(Object obj) {
        IAction action;
        TreeSet children = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof INavigatorItem && o2 instanceof INavigatorItem) {
                    return ((INavigatorItem)o1).getText().compareTo(((INavigatorItem)o2).getText());
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        if (obj instanceof TRCMonitor) {
            IAction action2 = this.getDefaultViewMappingForType("Monitor");
            if (action2 != null) {
                return action2;
            }
            children.addAll(((TRCMonitor)obj).getNodes());
        } else if (obj instanceof TRCNode) {
            IAction action3 = this.getDefaultViewMappingForType("Host");
            if (action3 != null) {
                return action3;
            }
            children.addAll(((TRCNode)obj).getProcessProxies());
        } else if (obj instanceof TRCProcessProxy) {
            children.addAll(((TRCProcessProxy)obj).getAgentProxies());
        } else if (obj instanceof CorrelationContainerProxy) {
            children.addAll(((CorrelationContainerProxy)obj).getCorrelatedAgents());
        } else if (obj instanceof TRCAgentProxy) {
            IAction action4;
            boolean hasViewer = false;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                if (this.getDefaultAction(iter.next()) == null) continue;
                hasViewer = true;
                break;
            }
            if (!hasViewer && (action4 = this.getDefaultViewMappingForType(((TRCAgentProxy)obj).getType())) != null) {
                return action4;
            }
        } else if (obj instanceof INavigatorItem && (action = this.getDefaultViewMappingForType(((INavigatorItem)obj).getType())) != null) {
            return action;
        }
        return null;
    }

    protected IAction getDefaultViewMappingForType(String type) {
        IAction[] actions = this.getViewMappingForTypeUnsorted(type);
        if (actions.length >= 1) {
            return actions[0];
        }
        return null;
    }
}

