/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util.ui;

import com.ibm.icu.text.DateFormat;
import java.security.cert.X509Certificate;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateDetails
extends Dialog {
    protected X509Certificate cert;

    public CertificateDetails(Shell shell) {
        super(shell);
    }

    public void init(X509Certificate cer) {
        this.cert = cer;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SecurityMessages._17);
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        data.widthHint = 450;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        if (this.cert == null) {
            Label errorIcon = new Label(content, 0);
            errorIcon.setImage(Display.getCurrent().getSystemImage(1));
            data = new GridData();
            data.verticalAlignment = 2;
            data.horizontalIndent = 5;
            errorIcon.setLayoutData((Object)data);
            Label lblErrMsg = new Label(content, 0);
            lblErrMsg.setText(SecurityMessages._72);
            data = new GridData();
            data.verticalAlignment = 8;
            data.horizontalIndent = 5;
            lblErrMsg.setLayoutData((Object)data);
            return content;
        }
        Label lblVersion = new Label(content, 0);
        lblVersion.setText(SecurityMessages._18);
        data = new GridData();
        data.horizontalIndent = 5;
        lblVersion.setLayoutData((Object)data);
        Label lblVersionValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblVersionValue.setLayoutData((Object)data);
        Label lblSubject = new Label(content, 0);
        lblSubject.setText(SecurityMessages._19);
        data = new GridData();
        data.horizontalIndent = 5;
        lblSubject.setLayoutData((Object)data);
        Label lblSubjectValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblSubjectValue.setLayoutData((Object)data);
        Label lblSigAlg = new Label(content, 0);
        lblSigAlg.setText(SecurityMessages._20);
        data = new GridData();
        data.horizontalIndent = 5;
        lblSigAlg.setLayoutData((Object)data);
        Label lblSigAlgValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblSigAlgValue.setLayoutData((Object)data);
        Label lblKey = new Label(content, 0);
        lblKey.setText(SecurityMessages._21);
        data = new GridData();
        data.horizontalIndent = 5;
        lblKey.setLayoutData((Object)data);
        Label lblKeyValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblKeyValue.setLayoutData((Object)data);
        Label lblPublicKey = new Label(content, 0);
        lblPublicKey.setText(SecurityMessages._22);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblPublicKey.setLayoutData((Object)data);
        Text lblPublicKeyValue = new Text(content, 2632);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 5;
        lblPublicKeyValue.setLayoutData((Object)data);
        Label lblValidity = new Label(content, 0);
        lblValidity.setText(SecurityMessages._28);
        data = new GridData();
        data.horizontalIndent = 5;
        lblValidity.setLayoutData((Object)data);
        Label lblValidityValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblValidityValue.setLayoutData((Object)data);
        Label lblIssuedTo = new Label(content, 0);
        lblIssuedTo.setText(SecurityMessages._26);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblIssuedTo.setLayoutData((Object)data);
        Label lblIssuedToValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblIssuedToValue.setLayoutData((Object)data);
        Label lblIssuedBy = new Label(content, 0);
        lblIssuedBy.setText(SecurityMessages._27);
        data = new GridData();
        data.horizontalIndent = 5;
        data.verticalAlignment = 1;
        lblIssuedBy.setLayoutData((Object)data);
        Label lblIssuedByValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblIssuedByValue.setLayoutData((Object)data);
        Label lblSerialNum = new Label(content, 0);
        lblSerialNum.setText(SecurityMessages._23);
        data = new GridData();
        data.horizontalIndent = 5;
        lblSerialNum.setLayoutData((Object)data);
        Label lblSerialNumValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblSerialNumValue.setLayoutData((Object)data);
        Label lblAlgorithm = new Label(content, 0);
        lblAlgorithm.setText(SecurityMessages._29);
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlgorithm.setLayoutData((Object)data);
        Label lblAlgorithmValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAlgorithmValue.setLayoutData((Object)data);
        Label lblSignature = new Label(content, 0);
        lblSignature.setText(SecurityMessages._24);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblSignature.setLayoutData((Object)data);
        Text lblSignatureValue = new Text(content, 2632);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 5;
        lblSignatureValue.setLayoutData((Object)data);
        lblVersionValue.setText(String.valueOf(this.cert.getType()) + " V." + this.cert.getVersion());
        lblSubjectValue.setText(this.cert.getSubjectDN().getName());
        lblSigAlgValue.setText(String.valueOf(this.cert.getSigAlgName()) + ", OID = " + this.cert.getSigAlgOID());
        lblKeyValue.setText(this.cert.getPublicKey().getAlgorithm());
        lblPublicKeyValue.setText(this.toHexString(this.cert.getPublicKey().getEncoded()));
        lblIssuedToValue.setText(this.cert.getSubjectDN().getName());
        lblIssuedByValue.setText(this.cert.getIssuerDN().getName());
        DateFormat df = DateFormat.getDateInstance((int)1);
        String validity = NLS.bind((String)SecurityMessages._30, (Object[])new Object[]{df.format(this.cert.getNotBefore()), df.format(this.cert.getNotAfter())});
        lblValidityValue.setText(validity);
        lblSerialNumValue.setText(this.cert.getSerialNumber().toString());
        lblAlgorithmValue.setText(this.cert.getSigAlgName());
        lblSignatureValue.setText(this.toHexString(this.cert.getSignature()));
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected String toHexString(byte[] data) {
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < data.length - 1) {
            hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
            if ((i + 1) % 16 == 0) {
                hexString.append("\n");
            } else if ((i + 1) % 8 == 0) {
                hexString.append("    ");
            } else {
                hexString.append(" ");
            }
            ++i;
        }
        while (i < data.length) {
            hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
            ++i;
        }
        return hexString.toString().toUpperCase();
    }
}

