/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util.ui;

import java.security.KeyStore;
import java.util.Enumeration;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveCertificate
extends Dialog {
    protected String alias = null;
    protected Text txtAliasValue = null;
    protected Button okBtn = null;
    protected String title = SecurityMessages._17;
    protected Label lblErrMsg = null;
    protected Label errorIcon = null;
    protected KeyStore ks = null;

    public SaveCertificate(Shell shell, KeyStore ks) {
        super(shell);
        this.ks = ks;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        data.widthHint = 450;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        this.errorIcon = new Label(content, 0);
        this.errorIcon.setImage(Display.getCurrent().getSystemImage(1));
        data = new GridData();
        data.horizontalIndent = 5;
        this.errorIcon.setLayoutData((Object)data);
        this.errorIcon.setVisible(false);
        this.lblErrMsg = new Label(content, 0);
        String text = SecurityMessages._65;
        text = text.length() > SecurityMessages._66.length() ? text : SecurityMessages._66;
        this.lblErrMsg.setText(text);
        data = new GridData();
        data.horizontalIndent = 5;
        this.lblErrMsg.setLayoutData((Object)data);
        this.lblErrMsg.setVisible(false);
        Label lblAlias = new Label(content, 0);
        lblAlias.setText(SecurityMessages._1);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblAlias.setLayoutData((Object)data);
        this.txtAliasValue = new Text(content, 2048);
        this.txtAliasValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = SaveCertificate.this.txtAliasValue.getText();
                if (value == null || value.trim().length() == 0) {
                    SaveCertificate.this.lblErrMsg.setVisible(true);
                    SaveCertificate.this.lblErrMsg.setText(SecurityMessages._65);
                    SaveCertificate.this.errorIcon.setVisible(true);
                    SaveCertificate.this.okBtn.setEnabled(false);
                } else {
                    try {
                        Enumeration<String> enu = SaveCertificate.this.ks.aliases();
                        while (enu.hasMoreElements()) {
                            String entry = enu.nextElement();
                            if (!entry.equals(value.trim())) continue;
                            SaveCertificate.this.lblErrMsg.setVisible(true);
                            SaveCertificate.this.lblErrMsg.setText(SecurityMessages._66);
                            SaveCertificate.this.errorIcon.setVisible(true);
                            SaveCertificate.this.okBtn.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {}
                    SaveCertificate.this.alias = value.trim();
                    SaveCertificate.this.lblErrMsg.setVisible(false);
                    SaveCertificate.this.errorIcon.setVisible(false);
                    SaveCertificate.this.okBtn.setEnabled(true);
                }
            }
        });
        data = new GridData(768);
        data.minimumHeight = 15;
        data.horizontalIndent = 5;
        this.txtAliasValue.setLayoutData((Object)data);
        return content;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okBtn.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public String getAlias() {
        return this.alias;
    }
}

