/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractFilteredContentProvider
implements ITreeContentProvider {
    protected ITreeContentProvider _content;

    public AbstractFilteredContentProvider(ITreeContentProvider content) {
        this._content = content;
    }

    public void dispose() {
        this._content.dispose();
    }

    public Object[] getChildren(Object parentElement) {
        return this.filter(this._content.getChildren(parentElement));
    }

    public Object[] getElements(Object inputElement) {
        return this.filter(this._content.getElements(inputElement));
    }

    public Object getParent(Object element) {
        Object parent = this._content.getParent(element);
        if (this.isSkipped(parent)) {
            return this.getParent(parent);
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._content.inputChanged(viewer, oldInput, newInput);
    }

    public abstract boolean isFiltered(Object var1);

    public abstract boolean isSkipped(Object var1);

    protected Object[] filter(Object[] elements) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (!this.isFiltered(elements[i])) {
                if (this.isSkipped(elements[i])) {
                    Object[] children = this.getChildren(elements[i]);
                    if (children != null && children.length > 0) {
                        list.addAll(Arrays.asList(children));
                    }
                } else {
                    list.add(elements[i]);
                }
            }
            ++i;
        }
        return list.toArray();
    }
}

