/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FilterTypeDialog
extends Dialog {
    protected TableViewer _typeListViewer;
    protected FilterInformationManager _fi;
    protected IFilterType _selectedFilterType;

    protected FilterTypeDialog(FilterInformationManager fi) {
        super(Display.getDefault().getActiveShell());
        this._fi = fi;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CommonUIMessages._79);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageLabel(composite);
        Composite listComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        listComposite.setLayout((Layout)layout);
        this._typeListViewer = new TableViewer(listComposite, 2050);
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        data.widthHint = 200;
        this._typeListViewer.getTable().setLayoutData((Object)data);
        this._typeListViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._typeListViewer.setLabelProvider((IBaseLabelProvider)new FilterTypeLabelProvider());
        this._typeListViewer.setContentProvider((IContentProvider)new FilterTypeContentProvider());
        this._typeListViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this._typeListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this._typeListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        this._typeListViewer.setInput((Object)this._fi);
        this._typeListViewer.setSorter(null);
        this._typeListViewer.refresh();
        this.setInitialSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.hyades.ui.mgrproftr");
        return composite;
    }

    protected Label createMessageLabel(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(CommonUIMessages._117);
        return label;
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
    }

    protected void setInitialSelection() {
        this.selectTableItem(this._typeListViewer.getTable(), 0);
    }

    protected void okPressed() {
        int selection = this._typeListViewer.getTable().getSelectionIndex();
        super.okPressed();
        this._selectedFilterType = this._fi.getFilterTypes()[selection];
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this._selectedFilterType = null;
    }

    public IFilterType selectedFilterType() {
        return this._selectedFilterType;
    }

    public class FilterTypeContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (FilterTypeDialog.this._fi != null && FilterTypeDialog.this._fi == inputElement) {
                return FilterTypeDialog.this._fi.getFilterTypes();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FilterTypeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((IFilterType)element).name();
        }

        public Image getImage(Object element) {
            ImageDescriptor icon = ((IFilterType)element).icon();
            if (icon != null) {
                return icon.createImage();
            }
            return null;
        }

        public void dispose() {
        }
    }
}

