/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersAdvancedUI;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;

public class FiltersDialog
extends TitleAreaDialog {
    protected FiltersStandardTabUI _standardTabUI;
    protected FiltersAdvancedUI _advancedTabUI;
    protected Text _filterNameText;
    protected FilterQueries _fq;
    protected FilterInformationManager _fi;
    protected int _openTabIndex;
    protected int _advancedTabSelectionIndex;
    protected String _errorMessage;
    protected String _originalFilterName;

    protected FiltersDialog(FilterQueries fq, FilterInformationManager fi, int openTabIndex, int advancedTabSelectionIndex) {
        super(Display.getDefault().getActiveShell());
        this._openTabIndex = openTabIndex;
        this._advancedTabSelectionIndex = advancedTabSelectionIndex;
        this._fq = fq;
        this._fi = fi;
        this._errorMessage = null;
    }

    protected void setTabUIs(FiltersStandardTabUI standardTabUI, FiltersAdvancedUI advancedTabUI) {
        this._standardTabUI = standardTabUI;
        this._advancedTabUI = advancedTabUI;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CommonUIMessages._79);
        this.setTitleImage(CommonUIImages.INSTANCE.getImage("filter_wiz.gif"));
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        content.setLayoutData((Object)data);
        this.createBlankContent(content, 10);
        this.createFilterNameControl(content);
        this.createBlankContent(content, 10);
        this.createTabsControl(content);
        Label separatorLine = new Label(content, 258);
        separatorLine.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.setTitle(CommonUIMessages._115);
        this.setMessage(CommonUIMessages._116);
        this.initialize();
        return content;
    }

    protected TabFolder createTabsControl(Composite parent) {
        TabItem item;
        TabFolder folder = new TabFolder(parent, 128);
        if (this._standardTabUI != null) {
            item = new TabItem(folder, 128);
            item.setText(this._standardTabUI.getTabName());
            item.setImage(this._standardTabUI.getTabImage());
            item.setControl(this._standardTabUI.createControl((Composite)folder));
        }
        if (this._advancedTabUI != null) {
            item = new TabItem(folder, 128);
            item.setText(this._advancedTabUI.getTabName());
            item.setImage(this._advancedTabUI.getTabImage());
            item.setControl(this._advancedTabUI.createControl((Composite)folder));
        }
        if (this._openTabIndex >= 0 && this._openTabIndex < folder.getItemCount()) {
            folder.setSelection(this._openTabIndex);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)folder, "org.eclipse.hyades.ui.mgrproftr");
        return folder;
    }

    protected Control createFilterNameControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)GridUtil.createFill());
        Label labelName = new Label(content, 0);
        labelName.setText(CommonUIMessages._100);
        this._filterNameText = new Text(content, 2048);
        GridData data = new GridData();
        data.widthHint = 250;
        this._filterNameText.setLayoutData((Object)data);
        this._filterNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent key) {
                if ("".equals(FiltersDialog.this._filterNameText.getText().trim())) {
                    FiltersDialog.this.setError(CommonUIMessages._114);
                } else if (CommonUIMessages._111.equalsIgnoreCase(FiltersDialog.this._filterNameText.getText().trim())) {
                    FiltersDialog.this.setError(CommonUIMessages._113);
                } else if (FiltersDialog.this._fi.filterNameExists(FiltersDialog.this._filterNameText.getText().trim()) && !FiltersDialog.this._originalFilterName.equals(FiltersDialog.this._filterNameText.getText().trim())) {
                    FiltersDialog.this.setError(CommonUIMessages._112);
                } else {
                    FiltersDialog.this.noError();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)content, "org.eclipse.hyades.ui.mgrproftr");
        return content;
    }

    protected Control createBlankContent(Composite parent, int heightHint) {
        Composite blankContent = new Composite(parent, 0);
        GridData data = new GridData();
        data.heightHint = heightHint;
        blankContent.setLayoutData((Object)data);
        return blankContent;
    }

    public void updateErrorCompleteState() {
        if (this._errorMessage != null) {
            this.setErrorMessage(this._errorMessage);
            this.setComplete(false);
            return;
        }
        if (this._standardTabUI != null && this._standardTabUI.getError() != null) {
            this.setErrorMessage(this._standardTabUI.getError());
            this.setComplete(false);
            return;
        }
        if (this._advancedTabUI != null && this._advancedTabUI.getError() != null) {
            this.setErrorMessage(this._advancedTabUI.getError());
            this.setComplete(false);
            return;
        }
        this.setErrorMessage(null);
        if (this._standardTabUI != null && !this._standardTabUI.getComplete()) {
            this.setComplete(false);
        }
        if (this._advancedTabUI != null && !this._advancedTabUI.getComplete()) {
            this.setComplete(false);
        }
        this.setComplete(true);
    }

    protected void setError(String error) {
        this._errorMessage = error;
        this.updateErrorCompleteState();
    }

    protected void noError() {
        this._errorMessage = null;
        this.updateErrorCompleteState();
    }

    protected void setComplete(boolean complete) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(complete);
        }
    }

    protected void okPressed() {
        this._fq.name(this._filterNameText.getText().trim());
        SimpleSearchQuery query = null;
        if (this._standardTabUI != null && (query = this._standardTabUI.performApply()) != null) {
            this._fq.standard(query);
        }
        if (this._advancedTabUI != null && (query = this._advancedTabUI.performApply()) != null) {
            this._fq.advanced(query);
        }
        super.okPressed();
    }

    protected void initialize() {
        this._filterNameText.setText(this._fq.name());
        this._originalFilterName = this._fq.name();
        if (this._standardTabUI != null) {
            this._standardTabUI.initializeFrom(this._fq.standard());
        }
        if (this._advancedTabUI != null) {
            this._advancedTabUI.initializeFrom(this._fq.advanced());
            this._advancedTabUI.selectItem(this._advancedTabSelectionIndex);
        }
    }
}

