/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.filters.internal.dialogs.FilterTypeDialog;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersDialog;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class FiltersEditDialog
extends Dialog {
    protected TableViewer _filtersListViewer;
    protected FilterInformationManager _fi;
    protected Button _newButton;
    protected Button _removeButton;
    protected Button _editButton;
    protected String _selectedFilterName = null;
    protected FilterQueries noFilter = null;
    private boolean showNoFilter = false;

    protected FiltersEditDialog(FilterInformationManager fi) {
        this(fi, false);
    }

    protected FiltersEditDialog(FilterInformationManager fi, boolean showNoFilter) {
        super(Display.getDefault().getActiveShell());
        this._fi = fi;
        this.showNoFilter = showNoFilter;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CommonUIMessages._79);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageLabel(composite);
        Composite listComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        listComposite.setLayout((Layout)layout);
        this._filtersListViewer = new TableViewer(listComposite, 2050);
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        data.widthHint = 200;
        this._filtersListViewer.getTable().setLayoutData((Object)data);
        this._filtersListViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.tableSelect();
            }
        });
        this._filtersListViewer.setLabelProvider((IBaseLabelProvider)new FilterSetLabelProvider());
        this._filtersListViewer.setContentProvider((IContentProvider)new FilterSetContentProvider());
        this._filtersListViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this._filtersListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this._filtersListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        if (!this.showNoFilter) {
            this.removeNoFilters();
        }
        this.createButtonsControl(composite);
        this._filtersListViewer.setInput((Object)this._fi);
        this._filtersListViewer.setSorter(null);
        this._filtersListViewer.refresh();
        this.setInitialSelection();
        this.enableButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.hyades.ui.mgrproftr");
        return composite;
    }

    protected Label createMessageLabel(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(CommonUIMessages._103);
        return label;
    }

    protected Control createButtonsControl(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(258);
        data.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)data);
        this._newButton = this.createModifyButton(buttonComposite, CommonUIMessages._104);
        this._newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.createFilterSet();
            }
        });
        this._editButton = this.createModifyButton(buttonComposite, CommonUIMessages._105);
        this._editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.editFilterSet();
            }
        });
        this._removeButton = this.createModifyButton(buttonComposite, CommonUIMessages._106);
        this._removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.removeFilterSets();
            }
        });
        this._newButton.setEnabled(true);
        return buttonComposite;
    }

    protected Button createModifyButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        button.setText(text);
        return button;
    }

    protected void createFilterSet() {
        String type;
        if (this._fi.getFilterTypes().length > 1) {
            FilterTypeDialog filterTypeDialog = FilterUIUtil.getFiltersTypeDialog(this._fi);
            filterTypeDialog.open();
            IFilterType filterType = filterTypeDialog.selectedFilterType();
            type = filterType.id();
        } else {
            type = this._fi.getFilterTypes()[0].id();
        }
        FilterQueries fq = this._fi.createFilterQueries(type);
        FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(fq, this._fi, 0);
        if (type == null) {
            return;
        }
        filtersDialog.open();
        if (filtersDialog.getReturnCode() == 0) {
            this._fi.addFilter(fq);
            this._filtersListViewer.refresh();
            this.setSelectedFilter(fq.name());
            this.enableButtons();
        }
    }

    protected void editFilterSet() {
        int idx = this._filtersListViewer.getTable().getSelectionIndex();
        if (idx != -1) {
            FilterQueries sel = this._fi.filter(idx);
            FilterQueries copy = sel.copy();
            FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(copy, this._fi, 0);
            filtersDialog.open();
            if (filtersDialog.getReturnCode() == 0) {
                this._fi.removeFilter(sel);
                this._fi.addFilter(copy);
                this._filtersListViewer.refresh();
                this.setSelectedFilter(copy.name());
            }
        }
    }

    protected void removeFilterSets() {
        int selection = this._filtersListViewer.getTable().getSelectionIndex();
        this._fi.removeFilters(this._filtersListViewer.getTable().getSelectionIndices());
        this._filtersListViewer.refresh();
        int size = this._fi.size();
        if (size > 0) {
            if (selection > 0 && selection < size) {
                this.selectTableItem(this._filtersListViewer.getTable(), selection - 1);
            } else {
                this.selectTableItem(this._filtersListViewer.getTable(), 0);
            }
        }
        this.enableButtons();
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
    }

    protected void enableButtons() {
        int selection = this._filtersListViewer.getTable().getSelectionIndex();
        int selectionCount = this._filtersListViewer.getTable().getSelectionCount();
        this._removeButton.setEnabled(this._fi.size() > 0 && selection != -1);
        this._editButton.setEnabled(this._fi.size() > 0 && selection != -1 && selectionCount == 1);
    }

    protected void tableSelect() {
        this.enableButtons();
    }

    protected void okPressed() {
        int selection = this._filtersListViewer.getTable().getSelectionIndex();
        String string = this._selectedFilterName = selection >= 0 ? this._fi.filter(selection).name() : CommonUIMessages._111;
        if (!this.showNoFilter) {
            this.addNoFilter();
        }
        this._fi.save();
        super.okPressed();
    }

    public boolean close() {
        this._fi.restore();
        return super.close();
    }

    public String selectedFilterName() {
        return this._selectedFilterName;
    }

    public void selectedFilterName(String selectedFilterName) {
        this._selectedFilterName = selectedFilterName;
    }

    protected void setInitialSelection() {
        this.setSelectedFilter(this._selectedFilterName);
    }

    protected void setSelectedFilter(String name) {
        if (name != null) {
            int i = 0;
            while (i < this._fi.size()) {
                if (name.equals(this._fi.filter(i).name())) {
                    this.selectTableItem(this._filtersListViewer.getTable(), i);
                    return;
                }
                ++i;
            }
        }
    }

    protected void removeNoFilters() {
        int i = 0;
        while (i < this._fi.size()) {
            FilterQueries filter = this._fi.filter(i);
            if (CommonUIMessages._111.equals(filter.name())) {
                this.noFilter = filter;
                this._fi.removeFilter(filter);
            }
            ++i;
        }
    }

    protected void addNoFilter() {
        if (this.noFilter != null) {
            this._fi.addFilter(this.noFilter);
        }
    }

    public class FilterSetContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (FiltersEditDialog.this._fi != null && FiltersEditDialog.this._fi == inputElement) {
                return FiltersEditDialog.this._fi.getFiltersArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FilterSetLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((FilterQueries)element).name();
        }

        public Image getImage(Object element) {
            ImageDescriptor icon = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(((FilterQueries)element).type()).icon();
            if (icon != null) {
                return icon.createImage();
            }
            return null;
        }

        public void dispose() {
        }
    }
}

