/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class FilterResourceHandler
extends FilterResourceFileHandler {
    protected static String TYPE_DIR = "/filterresources/";
    protected static String TYPE_FILE = ".filtxmi";
    protected static String FILTERS_FILE_NAME = "filters";
    protected static String DEFAULT_FILTER_KEY_PREFIX = "org.eclipse.hyades.ui.filters.internal.defaultFilters.";
    protected static FilterResourceHandler _instance = null;
    protected static List _filtersToAddOnInstanceLoad = null;
    protected static List _keysAddToPreferencesOnInstanceLoad = null;

    protected FilterResourceHandler(URI uri) {
        super(uri);
    }

    public static FilterResourceHandler instance() {
        if (_instance == null) {
            _instance = new FilterResourceHandler(FilterResourceHandler.createMasterListFileURI());
            FilterResourceHandler.addFiltersOnInstanceLoad(null);
            FilterResourceHandler.defaultFiltersAddedForKey(null, true);
        }
        return _instance;
    }

    public static URI createMasterListFileURI() {
        String fileName = String.valueOf(CommonPlugin.getDefault().getStateLocation().toString()) + TYPE_DIR + FILTERS_FILE_NAME + TYPE_FILE;
        return URI.createFileURI((String)fileName);
    }

    public FilterQueries createFilterQueries(String type) {
        return this.createFilterQueries(type, null, null);
    }

    public FilterQueries createFilterQueries(String type, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        return FilterResourceHandler.createFilterQueries(type, this.getNewFilterSetName(), standardQuery, advancedQuery);
    }

    public static FilterQueries createFilterQueries(String type, String name, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        FilterQueries fq = new FilterQueries();
        fq.type(type);
        fq.name(name);
        if (standardQuery != null) {
            fq.standard(standardQuery);
        } else {
            fq.standard(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());
        }
        if (advancedQuery != null) {
            fq.advanced(advancedQuery);
        } else {
            fq.advanced(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());
        }
        return fq;
    }

    protected String getNewFilterSetName() {
        String defaultName = CommonUIMessages._110;
        int i = 1;
        String name = defaultName;
        while (this.filter(name) != null) {
            name = String.valueOf(defaultName) + " (" + i + ")";
            ++i;
        }
        return name;
    }

    public static synchronized void addFiltersOnInstanceLoad(List filters) {
        if (_filtersToAddOnInstanceLoad == null) {
            _filtersToAddOnInstanceLoad = new ArrayList();
        }
        if (filters != null) {
            _filtersToAddOnInstanceLoad.addAll(filters);
        }
        if (_instance == null) {
            return;
        }
        int i = 0;
        while (i < _filtersToAddOnInstanceLoad.size()) {
            _instance.addFilter((FilterQueries)_filtersToAddOnInstanceLoad.get(i));
            ++i;
        }
        _instance.save();
        _filtersToAddOnInstanceLoad.clear();
    }

    public static synchronized boolean isDefaultFiltersAddedForKey(String key) {
        if (CommonUIPlugin.getDefault().getPluginPreferences().getBoolean(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key)) {
            return true;
        }
        if (_keysAddToPreferencesOnInstanceLoad != null) {
            int i = 0;
            while (i < _keysAddToPreferencesOnInstanceLoad.size()) {
                if (key.equals(_keysAddToPreferencesOnInstanceLoad.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static synchronized void defaultFiltersAddedForKey(String key, boolean added) {
        if (_keysAddToPreferencesOnInstanceLoad == null) {
            _keysAddToPreferencesOnInstanceLoad = new ArrayList();
        }
        if (key != null) {
            if (added) {
                _keysAddToPreferencesOnInstanceLoad.add(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key);
            } else {
                _keysAddToPreferencesOnInstanceLoad.remove(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key);
                CommonUIPlugin.getDefault().getPluginPreferences().setValue(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key, false);
                CommonUIPlugin.getDefault().savePluginPreferences();
            }
        }
        if (_instance == null) {
            return;
        }
        int i = 0;
        while (i < _keysAddToPreferencesOnInstanceLoad.size()) {
            CommonUIPlugin.getDefault().getPluginPreferences().setValue((String)_keysAddToPreferencesOnInstanceLoad.get(i), true);
            ++i;
        }
        CommonUIPlugin.getDefault().savePluginPreferences();
        _keysAddToPreferencesOnInstanceLoad.clear();
    }
}

