/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.util.ICommonUIHelper;

public class ScopeContainer {
    protected static ScopeContainer _instance = null;
    protected Map _scopeSelectedFilter = new HashMap();
    protected Map _scopeViewers = new HashMap();
    protected Map _viewerSelectedScope = new HashMap();

    protected ScopeContainer() {
    }

    public static ScopeContainer instance() {
        if (_instance == null) {
            _instance = new ScopeContainer();
        }
        return _instance;
    }

    public String getSelectedFilterName(String scope) {
        return (String)this._scopeSelectedFilter.get(scope);
    }

    public String[] setSelectedFilterName(String selectedFilterName) {
        Vector filters = FilterResourceHandler.instance().filters(selectedFilterName);
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < filters.size()) {
            FilterQueries filterQueries = (FilterQueries)filters.get(i);
            IFilterType filterType = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(filterQueries.type());
            String[] scope = filterType.scope();
            int j = 0;
            while (j < scope.length) {
                this.setSelectedFilterName(scope[j], selectedFilterName);
                ++j;
            }
            result.addAll(Arrays.asList(scope));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setSelectedFilterName(String scope, String selectedFilterName) {
        this._scopeSelectedFilter.put(scope, selectedFilterName);
    }

    public void addFilterViewer(IFilterViewer viewer) {
        if (viewer == null) {
            return;
        }
        String[] scope = viewer.getFilterScope();
        if (scope == null) {
            return;
        }
        int i = 0;
        while (i < scope.length) {
            this.addFilterViewer(scope[i], viewer);
            ++i;
        }
    }

    protected void addFilterViewer(String scope, IFilterViewer viewer) {
        Vector<IFilterViewer> viewersV = (Vector<IFilterViewer>)this._scopeViewers.get(scope);
        if (viewersV == null) {
            viewersV = new Vector<IFilterViewer>();
            this._scopeViewers.put(scope, viewersV);
        }
        if (!this.vectorContainersObject(viewersV, viewer)) {
            viewersV.addElement(viewer);
        }
    }

    protected boolean vectorContainersObject(Vector v, Object obj) {
        int i = 0;
        while (i < v.size()) {
            if (v.elementAt(i) == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeFilterViewer(IFilterViewer viewer) {
        if (viewer == null) {
            return;
        }
        String[] scope = viewer.getFilterScope();
        if (scope == null) {
            return;
        }
        int i = 0;
        while (i < scope.length) {
            this.removeFilterViewer(scope[i], viewer);
            ++i;
        }
    }

    protected void removeFilterViewer(String scope, IFilterViewer viewer) {
        Vector viewersV = (Vector)this._scopeViewers.get(scope);
        if (viewersV == null) {
            return;
        }
        viewersV.remove(viewer);
    }

    public IFilterViewer[] getFilterViewers(String scope) {
        Vector viewersV = (Vector)this._scopeViewers.get(scope);
        if (viewersV == null) {
            return new IFilterViewer[0];
        }
        IFilterViewer[] viewers = new IFilterViewer[viewersV.size()];
        viewersV.toArray(viewers);
        return viewers;
    }

    public void setSelectedScope(String viewer, String selectedScope) {
        this._viewerSelectedScope.put(viewer, selectedScope);
    }

    public String getSelectedScope(String viewer) {
        return (String)this._viewerSelectedScope.get(viewer);
    }

    public String[] scopes() {
        Set scopeKeys = this._scopeSelectedFilter.keySet();
        String[] scopes = new String[scopeKeys.size()];
        scopeKeys.toArray(scopes);
        return scopes;
    }

    public String[] viewers() {
        Set viewerKeys = this._viewerSelectedScope.keySet();
        String[] viewers = new String[viewerKeys.size()];
        viewerKeys.toArray(viewers);
        return viewers;
    }
}

