/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.action;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class CollapseAllAction
extends Action
implements IDisposable {
    protected TreeViewer treeViewer;

    public CollapseAllAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void dispose() {
        this.treeViewer = null;
    }

    public boolean isAvailable() {
        if (this.treeViewer == null) {
            return false;
        }
        TreeItem[] items = this.treeViewer.getTree().getItems();
        int i = 0;
        int maxi = items.length;
        while (i < maxi) {
            if (items[i].getExpanded()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CollapseAllAction useDefaultDecorators() {
        this.setText(CommonUIMessages._139);
        this.setToolTipText(CommonUIMessages._140);
        this.setImageDescriptor(this.getImageDescriptor("elcl16/collapseall.gif"));
        this.setHoverImageDescriptor(this.getImageDescriptor("elcl16/collapseall.gif"));
        return this;
    }

    public void run() {
        if (this.treeViewer == null || this.treeViewer.getControl().isDisposed()) {
            this.dispose();
        } else {
            this.treeViewer.collapseAll();
        }
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getBundle((String)"org.eclipse.ui").getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

