/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.dbresource;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Properties;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.ui.internal.dbresource.DBResourceSupportUICommon;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public abstract class DBResourceSupportUI
extends DBResourceSupportUICommon {
    protected Button enableDBRS;
    protected Group lrsGroup;
    protected PreferencePage preferencePage;
    protected Preferences preferenceStore;
    protected String currentStoreType;

    public DBResourceSupportUI(PreferencePage preferencePage, Preferences preferenceStore, String currentStoreType) {
        this.preferencePage = preferencePage;
        this.preferenceStore = preferenceStore;
        this.currentStoreType = currentStoreType;
    }

    public Control createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)GridDataUtil.createFill());
        Label lrsDesc = new Label(content, 64);
        lrsDesc.setText(this.getDescription());
        GridData data = GridDataUtil.createHorizontalFill();
        data.heightHint = 60;
        data.widthHint = 60;
        lrsDesc.setLayoutData((Object)data);
        this.enableDBRS = new Button(content, 32);
        this.enableDBRS.setText(this.getEnableDBResourceLabel());
        this.lrsGroup = new Group(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.lrsGroup.setLayout((Layout)layout);
        this.lrsGroup.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        super.populateGroupControl((Composite)this.lrsGroup);
        this.jdbcTestConnection = new Button((Composite)this.lrsGroup, 0);
        this.jdbcTestConnection.setText(CommonUIMessages._56);
        Label lrsNote = new Label(content, 64);
        lrsNote.setText(this.getNote());
        data = GridDataUtil.createHorizontalFill();
        data.heightHint = 60;
        data.widthHint = 60;
        lrsNote.setLayoutData((Object)data);
        this.enableDBRS.addSelectionListener((SelectionListener)this);
        this.jdbcTestConnection.addSelectionListener((SelectionListener)this);
        this.initializeValues(false);
        this.enableGroup(this.enableDBRS.getSelection());
        this.validateUserInput(true);
        return content;
    }

    public void initializeValues(boolean defaultValue) {
        if (defaultValue) {
            this.enableDBRS.setSelection(this.preferenceStore.getDefaultBoolean("lrsp_enable_lrsp"));
            this.jdbcLocation.setText(this.preferenceStore.getDefaultString("lrsp_jdbc_location"));
            this.isValidJDBCType();
            this.storeType.setText(this.preferenceStore.getDefaultString("lrsp_jdbc_type"));
            this.location.setText(this.preferenceStore.getDefaultString("lrsp_jdbc_connection"));
            this.username.setText(this.preferenceStore.getDefaultString("lrsp_jdbc_username"));
            this.password.setText(LoadersUtils.restorePassword((String)this.preferenceStore.getDefaultString("lrsp_jdbc_password")));
        } else {
            this.enableDBRS.setSelection(this.preferenceStore.getBoolean("lrsp_enable_lrsp"));
            this.jdbcLocation.setText(this.preferenceStore.getString("lrsp_jdbc_location"));
            this.isValidJDBCType();
            this.storeType.setText(this.preferenceStore.getString("lrsp_jdbc_type"));
            this.location.setText(this.preferenceStore.getString("lrsp_jdbc_connection"));
            this.username.setText(this.preferenceStore.getString("lrsp_jdbc_username"));
            this.password.setText(LoadersUtils.restorePassword((String)this.preferenceStore.getString("lrsp_jdbc_password")));
        }
    }

    public boolean storeValues() {
        Preferences newStore = ModelsHierarchyPlugin.getPlugin().getPluginPreferences();
        String currentResourcePostFix = this.getResourcePostFix();
        if (this.enableDBRS.getSelection()) {
            String newResourcePostFix = this.storeType.getText();
            newStore.setValue("largeResourceSupportCurrentDBType", this.storeType.getText());
            currentResourcePostFix = newResourcePostFix;
            newStore.setValue(String.valueOf(currentResourcePostFix) + "/" + "largeResourceSupportJDBCLocation", this.jdbcLocation.getText());
            newStore.setValue(String.valueOf(currentResourcePostFix) + "/" + "largeResourceSupportLocation", this.location.getText());
            newStore.setValue(String.valueOf(currentResourcePostFix) + "/" + "largeResourceSupportUsername", this.username.getText());
            newStore.setValue(String.valueOf(currentResourcePostFix) + "/" + "largeResourceSupportPassword", LoadersUtils.scramblePassword((String)this.password.getText()));
            Properties p = new Properties();
            HyadesResourceExtensions.getInstance().getAllProperties().put(currentResourcePostFix, p);
            p.setProperty("largeResourceSupportJDBCLocation", this.jdbcLocation.getText());
            p.setProperty("location", this.location.getText());
            p.setProperty("user", this.username.getText());
            p.setProperty("password", this.password.getText());
            p.setProperty("largeResourceSupportStoreType", this.storeType.getText());
            try {
                p.setProperty("largeResourceSupportJDBCLocation", new File(this.jdbcLocation.getText()).toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            newStore.setValue("largeResourceSupportCurrentDBType", "");
            newStore.setValue(String.valueOf(currentResourcePostFix) + "/" + "largeResourceSupportJDBCLocation", "");
            Properties p = new Properties();
            HyadesResourceExtensions.getInstance().getAllProperties().put(currentResourcePostFix, p);
            p.setProperty("largeResourceSupportJDBCLocation", "");
            p.setProperty("location", "");
            p.setProperty("user", "");
            p.setProperty("password", "");
            p.setProperty("largeResourceSupportStoreType", "");
        }
        this.storeUserInput();
        return true;
    }

    public void storeUserInput() {
        this.preferenceStore.setValue("lrsp_enable_lrsp", this.enableDBRS.getSelection());
        this.preferenceStore.setValue("lrsp_jdbc_location", this.jdbcLocation.getText());
        this.preferenceStore.setValue("lrsp_jdbc_type", this.storeType.getText());
        this.preferenceStore.setValue("lrsp_jdbc_connection", this.location.getText());
        this.preferenceStore.setValue("lrsp_jdbc_username", this.username.getText());
        this.preferenceStore.setValue("lrsp_jdbc_password", LoadersUtils.scramblePassword((String)this.password.getText()));
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget == this.enableDBRS) {
            this.enableGroup(this.enableDBRS.getSelection());
            String temp = this.storeType.getText();
            this.validateUserInput(false);
            if (temp != null) {
                this.storeType.setText(temp);
            }
        }
    }

    protected int getResourceKey() {
        Preferences store = CommonUIPlugin.getDefault().getPluginPreferences();
        return store.getInt("db_res_key");
    }

    protected String getResourcePostFix() {
        if (this.preferenceStore != null) {
            return this.preferenceStore.getString("db_res_postfix");
        }
        return "";
    }

    protected int getNextResourceKey() {
        Preferences store = CommonUIPlugin.getDefault().getPluginPreferences();
        int key = store.getInt("db_res_key");
        store.setValue("db_res_key", ++key);
        return key;
    }

    protected void validateUserInput(boolean skipJDBCcheck) {
        this.setPageComplete(true, null);
        if (this.enableDBRS.getSelection()) {
            if (!skipJDBCcheck && !this.isValidJDBCType()) {
                String jarLocation = this.jdbcLocation.getText();
                this.setPageComplete(false, jarLocation == null || jarLocation.equals("") ? null : CommonUIMessages._64);
            }
            if (this.jdbcLocation.getText().endsWith(String.valueOf(File.separator) + "db2jcc.jar")) {
                if (this.location == null || this.location.getText().equals("")) {
                    this.setPageComplete(false, CommonUIMessages._65);
                } else if (this.username == null || this.username.getText().equals("")) {
                    this.setPageComplete(false, CommonUIMessages._66);
                } else if (this.password == null || this.password.getText().equals("")) {
                    this.setPageComplete(false, CommonUIMessages._67);
                }
                this.enableJDBCTestConnection();
            }
        }
    }

    protected abstract String getEnableDBResourceLabel();

    protected abstract String getNote();

    protected abstract String getDescription();

    protected void setPageComplete(boolean complete, String incompleteMsg) {
        if (this.preferencePage != null) {
            this.preferencePage.setValid(complete);
            if (!complete && incompleteMsg != null) {
                this.preferencePage.setErrorMessage(incompleteMsg);
            } else {
                this.preferencePage.setErrorMessage(null);
            }
        }
    }
}

