/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.dbresource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyURIConverterImpl;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public abstract class DBResourceSupportUICommon
implements SelectionListener,
ModifyListener {
    protected Text username;
    protected Text password;
    protected Composite container;
    protected Combo storeType;
    protected Text location;
    protected Text jdbcLocation;
    protected Button jdbcBrowse;
    protected Button jdbcTestConnection;
    protected Shell shell;
    protected Label jdbcLoc;
    protected Label lDBType;
    protected Label lUsername;
    protected Label lPassword;

    public void populateGroupControl(Composite lrsGroup) {
        if (this.container == null) {
            this.container = lrsGroup;
        }
        this.jdbcLoc = new Label(lrsGroup, 0);
        this.jdbcLoc.setText(CommonUIMessages._54);
        Composite c = new Composite(lrsGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.jdbcLocation = new Text(c, 2048);
        this.jdbcLocation.setLayoutData((Object)new GridData(768));
        this.jdbcBrowse = new Button(c, 0);
        this.jdbcBrowse.setText(CommonUIMessages._55);
        this.lDBType = new Label(lrsGroup, 0);
        this.lDBType.setText(CommonUIMessages._61);
        this.storeType = new Combo(lrsGroup, 2056);
        this.storeType.setLayoutData((Object)new GridData(768));
        Label lLocation = new Label(lrsGroup, 0);
        lLocation.setText(CommonUIMessages._57);
        this.location = new Text(lrsGroup, 2048);
        this.location.setLayoutData((Object)new GridData(768));
        this.lUsername = new Label(lrsGroup, 0);
        this.lUsername.setText(CommonUIMessages._58);
        this.username = new Text(lrsGroup, 2048);
        this.username.setLayoutData((Object)new GridData(768));
        this.lPassword = new Label(lrsGroup, 0);
        this.lPassword.setText(CommonUIMessages._59);
        this.password = new Text(lrsGroup, 2048);
        this.password.setEchoChar('*');
        this.password.setLayoutData((Object)new GridData(768));
        Label lrsNote = new Label(lrsGroup, 64);
        lrsNote.setText(CommonUIMessages._60);
        GridData data = GridDataUtil.createHorizontalFill();
        data.heightHint = 60;
        data.widthHint = 60;
        data.horizontalSpan = 2;
        lrsNote.setLayoutData((Object)data);
        this.jdbcBrowse.addSelectionListener((SelectionListener)this);
        this.jdbcLocation.addModifyListener((ModifyListener)this);
        this.location.addModifyListener((ModifyListener)this);
        this.username.addModifyListener((ModifyListener)this);
        this.password.addModifyListener((ModifyListener)this);
        this.initializeValues(false);
        this.validateUserInput(true);
    }

    public abstract void initializeValues(boolean var1);

    public abstract boolean storeValues();

    public Composite getControl() {
        return this.container;
    }

    public void setStoreType(List l) {
        this.storeType.removeAll();
        if (l != null) {
            Collections.sort(l);
            int i = 0;
            while (i < l.size()) {
                String element = (String)l.get(i);
                this.storeType.add(element);
                ++i;
            }
            if (l.size() > 0) {
                this.storeType.select(0);
            }
        } else {
            this.storeType.removeAll();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.jdbcTestConnection) {
            Throwable exc;
            if (this.shell == null) {
                this.shell = this.container.getShell();
            }
            if ((exc = this.testConnection()) == null) {
                MessageDialog.openInformation((Shell)this.shell, (String)CommonUIMessages._56, (String)CommonUIMessages._68);
            } else {
                MessageDialog.openError((Shell)this.shell, (String)CommonUIMessages._56, (String)(String.valueOf(CommonUIMessages._69) + "\n" + exc.getLocalizedMessage()));
            }
        } else if (e.widget == this.jdbcBrowse) {
            this.showJDBCLocationDialog();
            this.enableJDBCInputs();
            this.validateUserInput(false);
        }
    }

    protected Throwable testConnection() {
        this.storeValues();
        URI testUri = URI.createURI((String)("testConnection-1234567890" + this.getAgentNamePostfix()));
        File f = new File("testConnection-1234567890" + this.getAgentNamePostfix());
        Resource resource = null;
        try {
            try {
                f.delete();
                resource = HierarchyResourceSetImpl.getInstance().createResource(testUri);
                TRCAgent agent = HierarchyFactory.eINSTANCE.createTRCAgent();
                resource.getContents().add((Object)agent);
                resource.save(Collections.EMPTY_MAP);
            }
            catch (Throwable e) {
                Throwable throwable = e;
                if (resource != null) {
                    HierarchyResourceSetImpl.getInstance().getResources().remove((Object)resource);
                }
                f.delete();
                return throwable;
            }
        }
        finally {
            if (resource != null) {
                HierarchyResourceSetImpl.getInstance().getResources().remove((Object)resource);
            }
            f.delete();
        }
        return null;
    }

    protected void deleteTestFile(URI testUri) {
        try {
            HierarchyURIConverterImpl c = new HierarchyURIConverterImpl();
            String filePath = c.toString(testUri);
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    protected String getAgentNamePostfix() {
        String res = null;
        String activeDBType = this.storeType.getText();
        for (Map.Entry entry : HyadesResourceExtensions.getInstance().entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
            String postfix = (String)entry.getKey();
            if (!postfix.endsWith(".trcadb") || !hyadesResourceFactory.getStoreType(postfix).equals(activeDBType)) continue;
            return postfix;
        }
        res = ".trcaxmi";
        return res;
    }

    protected void enableGroup(boolean enable) {
        this.jdbcLocation.setEnabled(enable);
        this.jdbcBrowse.setEnabled(enable);
        this.storeType.setEnabled(enable);
        if (enable) {
            this.enableJDBCInputs();
        } else {
            this.location.setEnabled(enable);
            this.username.setEnabled(enable);
            this.password.setEnabled(enable);
            this.jdbcTestConnection.setEnabled(enable);
        }
    }

    protected abstract void enableJDBCTestConnection();

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.jdbcLocation) {
            this.enableJDBCInputs();
            this.validateUserInput(false);
        } else {
            this.validateUserInput(true);
        }
    }

    protected abstract void validateUserInput(boolean var1);

    public void enableJDBCInputs() {
        boolean validJDBC = this.isNetworkMode();
        this.location.setEnabled(validJDBC);
        this.username.setEnabled(validJDBC);
        this.password.setEnabled(validJDBC);
        if (!validJDBC) {
            this.location.setText("");
            this.username.setText("");
            this.password.setText("");
        }
        this.enableJDBCTestConnection();
    }

    protected boolean isNetworkMode() {
        return this.jdbcLocation.getText().endsWith(String.valueOf(File.separator) + "db2jcc.jar") || this.jdbcLocation.getText().endsWith(String.valueOf(File.separator) + "derbyclient.jar") || this.jdbcLocation.getText().indexOf("mysql-connector-java") != -1;
    }

    protected boolean isValidJDBCType() {
        List<String> storeNames = new ArrayList<String>();
        String jarLocation = this.jdbcLocation.getText();
        if (jarLocation == null || jarLocation.equals("")) {
            storeNames.add(CommonUIMessages._63);
            this.setStoreType(storeNames);
            return false;
        }
        File trial = new File(jarLocation);
        if (trial == null || !trial.exists()) {
            storeNames.add(CommonUIMessages._62);
            this.setStoreType(storeNames);
            return false;
        }
        storeNames = this.getStoreTypeNames(trial);
        if (storeNames.size() == 0) {
            storeNames.add(CommonUIMessages._62);
            this.setStoreType(storeNames);
            return false;
        }
        this.setStoreType(storeNames);
        return true;
    }

    protected List getStoreTypeNames(File file) {
        ArrayList storeTypes = new ArrayList();
        HashSet processed = new HashSet();
        for (Map.Entry entry : HyadesResourceExtensions.getInstance().entrySet()) {
            if (processed.contains(entry.getKey()) || !(entry.getKey() instanceof String)) continue;
            processed.add(entry.getKey());
            List types = ((IHyadesResourceExtension)entry.getValue()).getStoreTypeNames(file);
            if (types == null || types.size() <= 0) continue;
            int s = types.size();
            int i = 0;
            while (i < s) {
                if (!storeTypes.contains(types.get(i))) {
                    storeTypes.add(types.get(i));
                }
                ++i;
            }
        }
        return storeTypes;
    }

    protected void showJDBCLocationDialog() {
        if (this.shell == null) {
            this.shell = this.container.getShell();
        }
        FileDialog dlg = new FileDialog(this.shell);
        dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dlg.open();
        String classpath = dlg.getFileName();
        if (classpath != null && !classpath.equals("")) {
            classpath = String.valueOf(dlg.getFilterPath()) + File.separator + classpath;
            this.jdbcLocation.setText(classpath);
        }
    }
}

