/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationDescriptor;
import org.eclipse.hyades.ui.internal.extension.AssociationDescriptorEntry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class AssociationMapping
implements IAssociationMapping {
    protected AssociationMappingRegistry associationMappingRegistry;
    protected String pluginId;
    protected List commonAssociationDescriptors;
    protected Map entryByType;
    protected String extensionPoint;
    protected boolean pluginRegistryWasLoaded = false;

    public AssociationMapping(AssociationMappingRegistry associationMappingRegistry, String extensionPoint, String pluginId) {
        this.associationMappingRegistry = associationMappingRegistry;
        this.extensionPoint = extensionPoint;
        this.pluginId = pluginId;
        this.commonAssociationDescriptors = new ArrayList();
        this.entryByType = new HashMap();
    }

    public void dispose() {
        this.associationMappingRegistry = null;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    protected ImageRegistry getImageRegistry() {
        return this.associationMappingRegistry.getImageRegistry();
    }

    public IAssociationMappingRegistry getAssociationMappingRegistry() {
        return this.associationMappingRegistry;
    }

    public String getExtensionPoint() {
        return this.extensionPoint;
    }

    public String[] getTypes() {
        this.loadPluginRegistry();
        return this.entryByType.keySet().toArray(new String[this.entryByType.keySet().size()]);
    }

    protected boolean hasAssociationDescriptors() {
        return !this.commonAssociationDescriptors.isEmpty() || !this.entryByType.isEmpty();
    }

    public IAssociationDescriptor[] associationDescriptors() {
        this.loadPluginRegistry();
        HashSet set = new HashSet(this.commonAssociationDescriptors);
        Iterator i = this.entryByType.values().iterator();
        while (i.hasNext()) {
            set.addAll(((AssociationDescriptorEntry)i.next()).getTypedAssociationDescriptor());
        }
        return set.toArray(new IAssociationDescriptor[set.size()]);
    }

    public IAssociationDescriptor[] getAssociationDescriptors() {
        this.loadPluginRegistry();
        return this.commonAssociationDescriptors.toArray(new IAssociationDescriptor[this.commonAssociationDescriptors.size()]);
    }

    public IAssociationDescriptor[] getAssociationDescriptors(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(CommonUIMessages._16);
        }
        this.loadPluginRegistry();
        return this.retrieveEntry(type).getAssociationDescriptors();
    }

    public IAssociationDescriptor getAssociationDescriptor(String id) {
        if (id == null) {
            return null;
        }
        IAssociationDescriptor[] descriptors = this.getAssociationDescriptors();
        int i = 0;
        int maxi = descriptors.length;
        while (i < maxi) {
            if (id.equals(descriptors[i].getId())) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    public IAssociationDescriptor getAssociationDescriptor(String type, String id) throws IllegalArgumentException {
        if (id == null) {
            return null;
        }
        IAssociationDescriptor[] descriptors = this.getAssociationDescriptors(type);
        int i = 0;
        int maxi = descriptors.length;
        while (i < maxi) {
            if (id.equals(descriptors[i].getId())) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    public IAssociationDescriptor getDefaultAssociationDescriptor() {
        this.loadPluginRegistry();
        if (this.commonAssociationDescriptors.isEmpty()) {
            return null;
        }
        return (IAssociationDescriptor)this.commonAssociationDescriptors.get(0);
    }

    public IAssociationDescriptor getDefaultAssociationDescriptor(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(CommonUIMessages._16);
        }
        this.loadPluginRegistry();
        return this.retrieveEntry(type).getDefault();
    }

    public synchronized boolean setDefaultAssociationDescriptor(IAssociationDescriptor associationDescriptor) throws IllegalArgumentException {
        if (associationDescriptor == null) {
            return false;
        }
        if (associationDescriptor.getAssociationMapping() != this) {
            throw new IllegalArgumentException(CommonUIMessages._15);
        }
        int index = this.commonAssociationDescriptors.indexOf(associationDescriptor);
        if (index == 0) {
            return true;
        }
        if (index > 0) {
            this.commonAssociationDescriptors.remove(index);
        }
        this.commonAssociationDescriptors.add(0, associationDescriptor);
        return associationDescriptor == this.commonAssociationDescriptors.get(0);
    }

    public synchronized boolean setDefaultAssociationDescriptor(String type, IAssociationDescriptor associationDescriptor) throws IllegalArgumentException {
        if (associationDescriptor == null) {
            return false;
        }
        if (type == null) {
            throw new IllegalArgumentException(CommonUIMessages._16);
        }
        if (associationDescriptor.getAssociationMapping() != this) {
            throw new IllegalArgumentException(CommonUIMessages._15);
        }
        if (!associationDescriptor.applyTo(type)) {
            throw new IllegalArgumentException(CommonUIMessages._15);
        }
        AssociationDescriptorEntry entry = this.retrieveEntry(type);
        entry.setDefault(associationDescriptor);
        return entry.getDefault() == associationDescriptor;
    }

    public boolean addToAvoidedSet(String type, IAssociationDescriptor associationDescriptor) {
        if (type == null || associationDescriptor == null || !associationDescriptor.applyTo(type)) {
            return false;
        }
        this.retrieveEntry(type).addToAvoidedSet(associationDescriptor);
        return true;
    }

    public IAssociationDescriptor[] getAvoidedAssociationDescriptors(String type) {
        if (type != null) {
            Set ret = this.retrieveEntry(type).avoidedAssociationDescriptors();
            return ret.toArray(new IAssociationDescriptor[ret.size()]);
        }
        return new IAssociationDescriptor[0];
    }

    public boolean removeAllFromAvoidSet(String type) {
        if (type == null) {
            return false;
        }
        this.retrieveEntry(type).removeAllFromAvoidedSet();
        return true;
    }

    public boolean removeFromAvoidedSet(String type, IAssociationDescriptor associationDescriptor) {
        if (type == null) {
            return false;
        }
        return this.retrieveEntry(type).removeFromAvoidedSet(associationDescriptor);
    }

    public IAssociationDescriptor createAssociationDescriptor() {
        AssociationDescriptor associationDescriptor = new AssociationDescriptor(this);
        this.commonAssociationDescriptors.add(associationDescriptor);
        return associationDescriptor;
    }

    protected synchronized void loadPluginRegistry() {
        if (!this.pluginRegistryWasLoaded) {
            if (this.pluginId != null) {
                IConfigurationElement[] hyadesUIConfigurationElements;
                IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.pluginId, this.getExtensionPoint());
                if (!this.pluginId.trim().equals("org.eclipse.hyades.ui") && (hyadesUIConfigurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.ui", this.getExtensionPoint())) != null && hyadesUIConfigurationElements.length > 0) {
                    IConfigurationElement[] temporaryConfigurationElements = new IConfigurationElement[configurationElements.length + hyadesUIConfigurationElements.length];
                    System.arraycopy(configurationElements, 0, temporaryConfigurationElements, 0, configurationElements.length);
                    System.arraycopy(hyadesUIConfigurationElements, 0, temporaryConfigurationElements, configurationElements.length, hyadesUIConfigurationElements.length);
                    configurationElements = temporaryConfigurationElements;
                }
                int counter = 0;
                while (counter < configurationElements.length) {
                    AssociationDescriptor associationDescriptor = new AssociationDescriptor(this);
                    associationDescriptor.loadFromConfigurationElement(configurationElements[counter]);
                    ++counter;
                }
            }
            this.pluginRegistryWasLoaded = true;
        }
    }

    protected synchronized AssociationDescriptorEntry retrieveEntry(String type) {
        if (type == null) {
            return null;
        }
        AssociationDescriptorEntry entry = (AssociationDescriptorEntry)this.entryByType.get(type);
        if (entry == null) {
            entry = new AssociationDescriptorEntry(this.commonAssociationDescriptors, type);
            this.entryByType.put(type, entry);
        }
        return entry;
    }

    protected synchronized void register(IAssociationDescriptor associationDescriptor) {
        if (!this.isValid(associationDescriptor)) {
            return;
        }
        if (!this.commonAssociationDescriptors.contains(associationDescriptor)) {
            this.commonAssociationDescriptors.add(associationDescriptor);
        }
    }

    protected boolean register(String type, IAssociationDescriptor associationDescriptor) {
        if (type == null) {
            return false;
        }
        if (!this.isValid(associationDescriptor)) {
            return false;
        }
        this.retrieveEntry(type).addTypedAssociationDescriptor(associationDescriptor);
        return true;
    }

    protected void deregister(IAssociationDescriptor associationDescriptor) {
        this.commonAssociationDescriptors.remove(associationDescriptor);
    }

    protected synchronized void deregister(String type, IAssociationDescriptor associationDescriptor) {
        if (type == null) {
            return;
        }
        AssociationDescriptorEntry entry = (AssociationDescriptorEntry)this.entryByType.get(type);
        if (entry == null) {
            return;
        }
        entry.removeTypedAssociationDescriptor(associationDescriptor);
    }

    protected boolean isValid(IAssociationDescriptor associationDescriptor) {
        IAssociationDescriptorFilter filter = this.associationMappingRegistry.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isValid(this, associationDescriptor);
    }
}

