/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.provisional.navigator.action.INavigatorActionContributor;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class NavigatorActionExtensionUtil {
    protected static final String EXT_PT_NAVIGATOR_ACTIONS = "org.eclipse.tptp.platform.common.ui.NavigatorActions";
    public static final String GP_IMPORT_LOG = "import.log";
    public static final String GP_EXPORT_LOG = "export.log";
    public static final String GP_IMPORT_SDB = "import.sdb";
    public static final String GP_EXPORT_SDB = "export.sdb";
    public static final String GP_ANALYSIS_LOG = "analysis.log";
    public static final String GP_SDB_EDITOR = "editor.sdb";
    public static final String GP_GENERIC = "generic";
    public static Set groups = null;
    protected NavigatorAction[] contributors;
    protected Map groupMap = new HashMap();

    protected void loadContributors() {
        if (groups == null) {
            this.initGroups();
        }
        if (this.contributors == null) {
            ArrayList<NavigatorAction> contributorList = new ArrayList<NavigatorAction>();
            IExtensionPoint extensionPt = Platform.getExtensionRegistry().getExtensionPoint(EXT_PT_NAVIGATOR_ACTIONS);
            IExtension[] extensions = extensionPt == null ? new IExtension[]{} : extensionPt.getExtensions();
            IConfigurationElement[] configElements = null;
            int l = extensions.length;
            int cel = 0;
            int i = 0;
            while (i < l) {
                configElements = extensions[i].getConfigurationElements();
                cel = configElements.length;
                if (configElements != null && cel != 0) {
                    int j = 0;
                    while (j < cel) {
                        try {
                            NavigatorAction adopter = new NavigatorAction();
                            adopter.setId(configElements[j].getAttribute("id"));
                            String group = configElements[j].getAttribute("group");
                            adopter.setGroup(this.isValidGroup(group) ? group : GP_GENERIC);
                            Object execExt = configElements[j].createExecutableExtension("class");
                            if (!(execExt instanceof INavigatorActionContributor)) {
                                CommonPlugin.logError((Throwable)new Exception(CommonUIMessages.invalidNavExtAction));
                            } else {
                                adopter.setActionContributor((INavigatorActionContributor)execExt);
                                contributorList.add(adopter);
                                Object list = this.groupMap.get(group);
                                ArrayList<NavigatorAction> alist = list == null ? new ArrayList<NavigatorAction>() : (ArrayList<NavigatorAction>)list;
                                alist.add(adopter);
                                this.groupMap.put(group, alist);
                            }
                        }
                        catch (Throwable t) {
                            CommonPlugin.logError((Throwable)t);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.contributors = contributorList.toArray(new NavigatorAction[contributorList.size()]);
        }
    }

    protected void initGroups() {
        groups = new HashSet();
        groups.add(GP_IMPORT_LOG);
        groups.add(GP_EXPORT_LOG);
        groups.add(GP_IMPORT_SDB);
        groups.add(GP_EXPORT_SDB);
        groups.add(GP_ANALYSIS_LOG);
        groups.add(GP_SDB_EDITOR);
        groups.add(GP_GENERIC);
    }

    protected boolean isValidGroup(String group) {
        if (group == null) {
            return false;
        }
        return groups.contains(group);
    }

    public List getGroup(String group) {
        if (this.contributors == null) {
            this.loadContributors();
        }
        return (List)this.groupMap.get(group);
    }

    public NavigatorAction[] getContributions() {
        if (this.contributors == null) {
            this.loadContributors();
        }
        return this.contributors;
    }

    public class NavigatorAction {
        protected String id;
        protected String group;
        protected INavigatorActionContributor actionContributor;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public INavigatorActionContributor getActionContributor() {
            return this.actionContributor;
        }

        public void setActionContributor(INavigatorActionContributor actionContributor) {
            this.actionContributor = actionContributor;
        }
    }
}

