/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.logicalfolder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.adapter.NamedElementPropertySource;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolderFactory;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LogicalFolder
extends NamedElementPropertySource
implements Comparable,
IDisposable,
IAdaptable,
INamedElement,
IPersistableElement {
    protected static final String PROP_CHILD_COUNT = CommonUIMessages._6;
    protected String name;
    protected String description;
    protected Object parent;
    protected List children;
    protected boolean isLinked;
    protected Object data;

    protected LogicalFolder() {
        this.setNamedElement(this);
        this.isLinked = false;
    }

    public LogicalFolder(String name) throws IllegalArgumentException {
        this();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(CommonUIMessages._10);
        }
        this.name = name;
    }

    public LogicalFolder(Object parent, String name) throws IllegalArgumentException {
        this(name);
        if (parent == null) {
            throw new IllegalArgumentException(NLS.bind((String)CommonUIMessages._9, (Object)"parent"));
        }
        this.parent = parent;
    }

    public void dispose() {
        if (!this.isLinked()) {
            this.children.clear();
        }
        this.data = null;
        this.parent = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return this;
        }
        if (adapter == IPersistableElement.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public void linkChildren(List childrenList) {
        this.isLinked = true;
        this.children = Collections.unmodifiableList(childrenList);
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    protected List createChildren() {
        return new ArrayList();
    }

    public Object getParent() {
        return this.parent;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        LogicalFolder viewerFolder = (LogicalFolder)o;
        if (this.parent == null) {
            if (viewerFolder.parent == null) {
                return this.name.compareTo(viewerFolder.name);
            }
            return -1;
        }
        if (viewerFolder.parent == null) {
            return 1;
        }
        if (this.parent.equals(viewerFolder.parent)) {
            return this.name.compareTo(viewerFolder.name);
        }
        return this.parent.hashCode() - viewerFolder.parent.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalFolder)) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        if (this.parent != null) {
            return 3 * this.parent.hashCode() + this.name.hashCode();
        }
        return this.name.hashCode();
    }

    protected IPropertyDescriptor[] addPropertyDescriptors() {
        if (this.children != null && this.children.size() > 0) {
            PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[]{new PropertyDescriptor((Object)PROP_CHILD_COUNT, PROP_CHILD_COUNT.toLowerCase())};
            propertyDescriptors[0].setCategory(PROP_INFO);
            propertyDescriptors[0].setAlwaysIncompatible(true);
            return propertyDescriptors;
        }
        return super.addPropertyDescriptors();
    }

    public Object getPropertyValue(Object id) {
        if (PROP_CHILD_COUNT.equals(id)) {
            return Integer.toString(this.getChildren().size());
        }
        return super.getPropertyValue(id);
    }

    public String getFactoryId() {
        return LogicalFolderFactory.class.getName();
    }

    public void saveState(IMemento memento) {
        LogicalFolderFactory.save(memento, this);
    }
}

