/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;

public class TreeNavigatorFrameSource
extends TreeViewerFrameSource {
    protected ITreeNavigator treeNavigator;

    public TreeNavigatorFrameSource(ITreeNavigator treeNavigator) {
        super((AbstractTreeViewer)treeNavigator.getTreeViewer());
        this.treeNavigator = treeNavigator;
    }

    protected ITreeNavigator getTreeNavigator() {
        return this.treeNavigator;
    }

    protected TreeFrame createFrame(Object input) {
        TreeFrame frame = super.createFrame(input);
        frame.setName(this.treeNavigator.getFrameName(input));
        frame.setToolTipText(this.treeNavigator.getFrameToolTipText(input));
        return frame;
    }

    protected void frameChanged(TreeFrame frame) {
        IProject project;
        Object input = frame.getInput();
        if (input instanceof IResource && (project = ((IResource)input).getProject()) != null && !project.isOpen()) {
            MessageDialog.openInformation((Shell)this.treeNavigator.getViewSite().getShell(), (String)CommonUIMessages._142, (String)MessageFormat.format((String)CommonUIMessages._143, (Object[])new Object[]{project.getName()}));
            this.treeNavigator.getFrameList().back();
            return;
        }
        super.frameChanged(frame);
        this.treeNavigator.updateTitle();
    }
}

