/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public abstract class NavigatorActionGroup
extends ActionGroup
implements IDisposable {
    public static final String GROUP_FILTERS = "group.filters";
    protected Separator fAdditionsGroup;
    protected Separator fNewGroup;
    protected Separator fOpenGroup;
    protected Separator fDeleteGroup;
    protected Separator fSaveGroup;
    protected Separator fImportGroup;
    protected Separator fRefreshGroup;
    protected Separator fWorkbenchAdditionsGroup;
    protected Separator fPropertiesGroup;
    protected INavigator navigator;

    public NavigatorActionGroup(INavigator navigator) {
        this.navigator = navigator;
        this.createActions();
        this.createActionGroups();
    }

    public void dispose() {
        this.navigator = null;
        this.disposeActionGroups();
        super.dispose();
    }

    public INavigator getNavigator() {
        return this.navigator;
    }

    public void handleKeyPressed(KeyEvent event) {
    }

    protected void createActions() {
    }

    protected void createActionGroups() {
        this.fAdditionsGroup = new Separator("group.additions");
        this.fNewGroup = new Separator("group.new");
        this.fOpenGroup = new Separator("org.eclipse.ui.OpenWithSubMenu");
        this.fDeleteGroup = new Separator("group.delete");
        this.fSaveGroup = new Separator("group.save");
        this.fImportGroup = new Separator("group.import");
        this.fRefreshGroup = new Separator("group.refresh");
        this.fWorkbenchAdditionsGroup = new Separator("additions");
        this.fPropertiesGroup = new Separator("group.properties");
    }

    protected void disposeActionGroups() {
        if (this.fAdditionsGroup != null) {
            this.fAdditionsGroup.dispose();
            this.fAdditionsGroup = null;
        }
        if (this.fNewGroup != null) {
            this.fNewGroup.dispose();
            this.fNewGroup = null;
        }
        if (this.fOpenGroup != null) {
            this.fOpenGroup.dispose();
            this.fOpenGroup = null;
        }
        if (this.fDeleteGroup != null) {
            this.fDeleteGroup.dispose();
            this.fDeleteGroup = null;
        }
        if (this.fSaveGroup != null) {
            this.fSaveGroup.dispose();
            this.fSaveGroup = null;
        }
        if (this.fImportGroup != null) {
            this.fImportGroup.dispose();
            this.fImportGroup = null;
        }
        if (this.fRefreshGroup != null) {
            this.fRefreshGroup.dispose();
            this.fRefreshGroup = null;
        }
        if (this.fWorkbenchAdditionsGroup != null) {
            this.fWorkbenchAdditionsGroup.dispose();
            this.fWorkbenchAdditionsGroup = null;
        }
        if (this.fPropertiesGroup != null) {
            this.fPropertiesGroup.dispose();
            this.fPropertiesGroup = null;
        }
    }

    public void runDefaultAction(IStructuredSelection selection) {
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)this.fAdditionsGroup);
        menu.add((IContributionItem)this.fNewGroup);
        menu.add((IContributionItem)this.fOpenGroup);
        menu.add((IContributionItem)this.fDeleteGroup);
        menu.add((IContributionItem)this.fSaveGroup);
        menu.add((IContributionItem)this.fImportGroup);
        menu.add((IContributionItem)this.fRefreshGroup);
        menu.add((IContributionItem)this.fWorkbenchAdditionsGroup);
        menu.add((IContributionItem)this.fPropertiesGroup);
        NavigatorExtensionUtil.fillContextMenu(menu, this.navigator.getStructuredSelection(), this.navigator.getID());
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }
}

