/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class ResourceChangeUpdaterProvider
implements IResourceChangeListener,
IDisposable {
    protected IResourceChangeUpdater resourceChangeUpdater;

    public void dispose() {
        this.resourceChangeUpdater = null;
    }

    public void setResourceChangeUpdater(IResourceChangeUpdater resourceChangeUpdater) {
        this.resourceChangeUpdater = resourceChangeUpdater;
    }

    public IResourceChangeUpdater getResourceChangeUpdater() {
        return this.resourceChangeUpdater;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.getResourceChangeUpdater() == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        this.doProcessDelta(event.getDelta());
    }

    protected void doProcessDelta(IResourceDelta delta) {
        this.getResourceChangeUpdater().started();
        try {
            try {
                this.processDelta(delta);
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
                try {
                    this.getResourceChangeUpdater().ended();
                }
                catch (Exception e2) {
                    CommonPlugin.logError((Throwable)e2);
                }
            }
        }
        finally {
            try {
                this.getResourceChangeUpdater().ended();
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
    }

    protected void processDelta(IResourceDelta delta) {
        int i;
        IResourceChangeUpdater resChangeUpdater = this.getResourceChangeUpdater();
        if (resChangeUpdater == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            int flags = affectedChildren[i2].getFlags();
            if ((flags & 0x8000) != 0 ? resChangeUpdater.updateChildrenType(resource) : (flags & 0x100) != 0 && resChangeUpdater.updateContent(resource, affectedChildren[i2].getResource())) {
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x10000) != 0 && resChangeUpdater.updateProperties(resource)) {
            return;
        }
        if ((changeFlags & 0x4000) != 0) {
            resChangeUpdater.refreshContent(resource);
        }
        if ((changeFlags & 0x40000) != 0 && resChangeUpdater.replaced(resource)) {
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3]);
            ++i3;
        }
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            IResource[] affected = new IResource[affectedChildren.length];
            i = 0;
            while (i < affectedChildren.length) {
                affected[i] = affectedChildren[i].getResource();
                ++i;
            }
            if (resChangeUpdater.remove(resource, affected)) {
                return;
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            IResource[] affected = new IResource[affectedChildren.length];
            i = 0;
            while (i < affectedChildren.length) {
                affected[i] = affectedChildren[i].getResource();
                ++i;
            }
            if (resChangeUpdater.add(resource, affected)) {
                return;
            }
        }
        i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    public static class UIUpdaterProvider
    extends ResourceChangeUpdaterProvider {
        protected IResourceDelta delta;
        protected boolean asynOperation;

        public UIUpdaterProvider() {
            this(false);
        }

        public UIUpdaterProvider(boolean isAsynch) {
            this.asynOperation = isAsynch;
        }
    }
}

