/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.report;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.internal.classloader.PathEntriesClassLoader;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class ReportDescription
implements IReportDescription {
    protected String name = null;
    protected String className = null;
    protected String classPath = null;
    protected IReportGenerator reportGenerator = null;
    protected IConfigurationElement configurationElement;
    protected ClassLoader parentClassLoader;

    public ReportDescription(ClassLoader parentClassLoader, String name, String className, String classPath) {
        this.name = name;
        this.className = className;
        this.classPath = classPath;
        this.parentClassLoader = parentClassLoader;
    }

    public ReportDescription(String name, String className, String classPath, IConfigurationElement configurationElement) {
        this.name = name;
        this.className = className;
        this.classPath = classPath;
        this.configurationElement = configurationElement;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public IReportGenerator getReportGenerator() throws Exception {
        if (this.reportGenerator == null) {
            if (this.configurationElement == null) {
                String className = this.getClassName();
                String classPath = this.getClassPath();
                PathEntriesClassLoader classLoader = new PathEntriesClassLoader(this.parentClassLoader, classPath);
                try {
                    this.reportGenerator = (IReportGenerator)classLoader.loadClass(className).newInstance();
                }
                catch (Throwable e) {
                    CommonPlugin.logError((Throwable)e);
                    return null;
                }
                this.reportGenerator.setUsedClasspath(classPath);
            } else {
                try {
                    this.reportGenerator = (IReportGenerator)this.configurationElement.createExecutableExtension("class");
                }
                catch (Throwable e) {
                    CommonPlugin.logError((Throwable)e);
                    return null;
                }
            }
        }
        return this.reportGenerator;
    }

    public boolean isDefinedByPlugin() {
        return this.configurationElement != null;
    }

    public void setClassName(String string) {
        this.className = string;
        this.reportGenerator = null;
    }

    public void setClassPath(String string) {
        this.classPath = string;
        this.reportGenerator = null;
    }

    public void setName(String string) {
        this.name = string;
    }
}

