/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.report;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.ILogger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportManager
implements IDisposable {
    protected static String prefKey = "reportDescriptions";
    protected List pluginReportDescription;
    protected List preferenceReportDescription = new ArrayList();
    protected AbstractUIPlugin plugin;
    protected String extensionPoint;
    protected static ReportManager reportManager;

    public ReportManager(AbstractUIPlugin plugin, String extensionPoint) {
        this.plugin = plugin;
        this.extensionPoint = extensionPoint;
    }

    public void dispose() {
        if (this.pluginReportDescription != null) {
            this.pluginReportDescription.clear();
        }
        this.preferenceReportDescription.clear();
        this.plugin = null;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.plugin.getPreferenceStore();
    }

    public void addReportDefinition(IReportDescription reportDescription) {
        this.preferenceReportDescription.add(reportDescription);
    }

    public void removeReportDefinition(IReportDescription reportDescription) {
        this.preferenceReportDescription.remove(reportDescription);
    }

    public IReportDescription[] getPreferenceStoreReportDescriptions() {
        return this.preferenceReportDescription.toArray(new ReportDescription[this.preferenceReportDescription.size()]);
    }

    public IReportDescription[] getReportDescriptions() {
        ArrayList ret = null;
        if (this.pluginReportDescription != null) {
            ret = new ArrayList(this.pluginReportDescription);
            ret.addAll(this.preferenceReportDescription);
        } else {
            ret = this.preferenceReportDescription;
        }
        return ret.toArray(new ReportDescription[ret.size()]);
    }

    public void loadFromPluginRegistry() {
        if (this.pluginReportDescription != null) {
            return;
        }
        this.pluginReportDescription = new ArrayList();
        if (this.plugin != null) {
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tptp.platform.common.ui", this.extensionPoint);
            int i = 0;
            int maxi = configurationElements.length;
            while (i < maxi) {
                if ("reportDescription".equals(configurationElements[i].getName())) {
                    String name = configurationElements[i].getAttribute("name");
                    String className = configurationElements[i].getAttribute("class");
                    this.pluginReportDescription.add(new ReportDescription(name, className, "", configurationElements[i]));
                }
                ++i;
            }
        }
    }

    public void loadFromPreferenceStore() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String value = preferenceStore.getString(prefKey);
        if (value == null || value.length() == 0) {
            return;
        }
        XMLUtil.setLogger((ILogger)CommonPlugin.getLogger());
        Element registryElement = XMLUtil.loadDom((String)value, (String)"reportDescriptions");
        if (registryElement == null) {
            return;
        }
        NodeList nodeList = XMLUtil.getChildrenByName((Element)registryElement, (String)"reportDescription");
        int i = 0;
        int maxi = nodeList.getLength();
        while (i < maxi) {
            if (nodeList.item(i) instanceof Element) {
                this.loadDescription((Element)nodeList.item(i));
            }
            ++i;
        }
    }

    protected void loadDescription(Element descriptionElement) {
        String name = XMLUtil.getValue((Element)descriptionElement, (String)"name");
        String clas = XMLUtil.getValue((Element)descriptionElement, (String)"class");
        if (name == null || clas == null) {
            return;
        }
        String classpath = XMLUtil.getValue((Element)descriptionElement, (String)"classpath");
        classpath = XMLUtil.removeXMLSymbols((String)classpath);
        ReportDescription report = new ReportDescription(this.plugin.getClass().getClassLoader(), name, clas, classpath);
        this.preferenceReportDescription.add(report);
    }

    public void saveIntoPreferenceStore() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml");
        xml.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
        xml.append("?>");
        xml.append("<reportDescriptions>");
        for (IReportDescription reportGeneratorDefinition : this.preferenceReportDescription) {
            this.storeDescription(xml, reportGeneratorDefinition);
        }
        xml.append("</reportDescriptions>");
        String xmlString = xml.toString();
        if (xmlString.equals(preferenceStore.getString(prefKey))) {
            return;
        }
        preferenceStore.setValue(prefKey, xmlString);
    }

    protected void storeDescription(StringBuffer xml, IReportDescription reportDefinition) {
        StringBuffer tempXML = new StringBuffer();
        tempXML.append("<reportDescription");
        tempXML.append(XMLUtil.createXMLAttribute((String)"name", (String)reportDefinition.getName(), (boolean)false));
        tempXML.append(XMLUtil.createXMLAttribute((String)"class", (String)reportDefinition.getClassName(), (boolean)false));
        tempXML.append(XMLUtil.createXMLAttribute((String)"classpath", (String)reportDefinition.getClassPath(), (boolean)false));
        tempXML.append("/>");
        xml.append(tempXML);
    }

    public static ReportManager getInstance() {
        if (reportManager == null) {
            reportManager = new ReportManager(CommonUIPlugin.getDefault(), "reportExtensions");
            reportManager.loadFromPluginRegistry();
            reportManager.loadFromPreferenceStore();
        }
        return reportManager;
    }
}

