/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.util.UIUtil;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;

public class HyadesReportExtensionsWizard
extends ReportGeneratorWizard {
    protected LocationPage locationPage;
    protected IReportGenerator generator;

    public HyadesReportExtensionsWizard(IReportGenerator generator) {
        this.setWindowTitle(CommonUIMessages._152);
        this.generator = generator;
    }

    protected void initPages() {
        this.locationPage = new LocationPage("location", this.adjustLocation());
        this.locationPage.setTitle(CommonUIMessages._152);
        this.locationPage.setDescription(CommonUIMessages._154);
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            this.locationPage.setFileExtension(fileExtension);
            this.locationPage.setFileName("*." + fileExtension);
        }
    }

    protected String getFileExtension() {
        return null;
    }

    protected IStructuredSelection adjustLocation() {
        IResource res;
        IContainer parent;
        IStructuredSelection structuredSelection = this.getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource && (parent = (res = (IResource)selection).getParent()) != null && parent.exists()) {
            structuredSelection = new StructuredSelection((Object)parent);
        }
        return structuredSelection;
    }

    protected void addReportPages() throws Exception {
        this.addPage((IWizardPage)this.locationPage);
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        IFile file = null;
        IPath path = this.locationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        file = res.getFile(path);
        if (file == null) {
            throw new Exception("Exception caught when retrieving the file");
        }
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)CommonUIMessages._158, (String)CommonUIMessages._159)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            if (this.generator != null) {
                inputStream = this.generator.generate(file, (ISelection)this.getSelection());
            }
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
            String error = e.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = e.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)CommonUIMessages._8, (String)NLS.bind((String)CommonUIMessages._160, (Object)error));
            return null;
        }
        if (inputStream == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)CommonUIMessages._8, (String)CommonUIMessages._161);
            return null;
        }
        try {
            if (file.exists()) {
                file.delete(true, true, null);
            }
            file.create(inputStream, true, null);
        }
        catch (CoreException e) {
            CommonPlugin.logError((Throwable)e);
            UIUtil.openSaveFileErrorDialog(this.getShell(), file.getFullPath().toString(), e);
            return null;
        }
        return file;
    }

    protected IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        CommonPlugin.logError((Throwable)e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        CommonPlugin.logError((Throwable)e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            CommonPlugin.logError((Throwable)exc);
            exc.printStackTrace();
        }
        return container;
    }

    public boolean isAvailable(ISelection selection) {
        return true;
    }
}

