/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.provisional.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.internal.context.ContextHandlerImpl;
import org.eclipse.hyades.ui.internal.context.ContextLanguageImpl;
import org.eclipse.hyades.ui.internal.context.ContextMappingPreference;
import org.eclipse.hyades.ui.provisional.context.IContextHandler;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.provisional.context.IContextProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class ContextManager {
    protected static ContextManager instance;
    protected final String CONTEXTS_EXTENTION_POINT = "contexts";
    protected final String CONTEXT_ELEMENT = "context";
    protected final String CONTEXT_PROVIDERS_EXTENTION_POINT = "contextProviders";
    protected final String CONTEXT_PROVIDER_ELEMENT = "contextProvider";
    protected Map contextLanguageByKey;
    protected Map contextHandlersByKey;
    protected ContextMappingPreference contextMappingPreference = new ContextMappingPreference(CommonUIPlugin.getDefault().getPreferenceStore());

    protected ContextManager() {
    }

    public static ContextManager instance() {
        if (instance == null) {
            instance = new ContextManager();
        }
        return instance;
    }

    protected void initialize() {
        this.initializeContextLanguage();
        this.initializeContextProviders();
    }

    protected void initializeContextLanguage() {
        this.contextLanguageByKey = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.ui", "contexts");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String pluginID = elem.getDeclaringExtension().getNamespace();
                if (elem.getName().equals("context")) {
                    String id = elem.getAttribute("id");
                    String key = elem.getAttribute("contextKey");
                    String name = elem.getAttribute("name");
                    String description = elem.getAttribute("description");
                    if (id != null && key != null && name != null) {
                        String iconPath = elem.getAttribute("icon");
                        ImageDescriptor imageDescriptor = CommonUIPlugin.imageDescriptorFromPlugin((String)pluginID, (String)iconPath);
                        ContextLanguageImpl cl = new ContextLanguageImpl(id, key, name, description, imageDescriptor);
                        this.contextLanguageByKey.put(cl.contextKey(), cl);
                    }
                }
                ++i;
            }
        }
    }

    protected void initializeContextProviders() {
        this.contextHandlersByKey = new HashMap();
        IContextLanguage[] contexts = ContextManager.getContextLanguages();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.ui", "contextProviders");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                if (elem.getName().equals("contextProvider")) {
                    String id = elem.getAttribute("id");
                    IContextProvider contextProvider = null;
                    try {
                        if (!"".equals(elem.getAttribute("class"))) {
                            Object clz = elem.createExecutableExtension("class");
                            if (clz instanceof IContextProvider) {
                                contextProvider = (IContextProvider)clz;
                            } else {
                                CommonPlugin.logError((String)"Class in extension point org.eclipse.hyades.uicontextProviders must implement IContextProvider");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String excludeContext = elem.getAttribute("excludeContext");
                    IConfigurationElement[] contextsElems = elem.getChildren("contexts");
                    Vector<String> contextsV1 = new Vector<String>();
                    int k = 0;
                    while (k < contextsElems.length) {
                        contextsV1.addElement(contextsElems[k].getChildren()[0].getAttribute("refID"));
                        ++k;
                    }
                    String[] contextsA = new String[contextsV1.size()];
                    contextsV1.toArray(contextsA);
                    if (id != null && contextProvider != null) {
                        ContextHandlerImpl ch = new ContextHandlerImpl(id, contextProvider, "true".equals(excludeContext), contextsA.length == 0 ? null : contextsA);
                        int j = 0;
                        while (j < contexts.length) {
                            Vector<ContextHandlerImpl> contextsV = (Vector<ContextHandlerImpl>)this.contextHandlersByKey.get(contexts[j].contextKey());
                            if (contextsV == null) {
                                contextsV = new Vector<ContextHandlerImpl>();
                                this.contextHandlersByKey.put(contexts[j].contextKey(), contextsV);
                            }
                            if (this.keyInContextHandler(contexts[j].contextKey(), ch)) {
                                contextsV.addElement(ch);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected boolean keyInContextHandler(String key, IContextHandler ch) {
        if (ch.contexts() == null) {
            return !ch.excludeContexts();
        }
        int i = 0;
        while (i < ch.contexts().length) {
            if (key.equals(ch.contexts()[i])) {
                return !ch.excludeContexts();
            }
            ++i;
        }
        return ch.excludeContexts();
    }

    protected IContextLanguage internalGetContextLanguage(String contextKey) {
        if (this.contextLanguageByKey == null) {
            this.initialize();
        }
        return (IContextLanguage)this.contextLanguageByKey.get(contextKey);
    }

    public static IContextLanguage getContextLanguage(String contextKey) {
        return ContextManager.instance().internalGetContextLanguage(contextKey);
    }

    protected IContextLanguage[] internalGetContextLanguages() {
        if (this.contextLanguageByKey == null) {
            this.initialize();
        }
        IContextLanguage[] contexts = new IContextLanguage[this.contextLanguageByKey.size()];
        this.contextLanguageByKey.values().toArray(contexts);
        return contexts;
    }

    public static IContextLanguage[] getContextLanguages() {
        return ContextManager.instance().internalGetContextLanguages();
    }

    protected IContextHandler getContextHandlerById(String contextKey, String id) {
        IContextHandler[] ch = this.internalGetContextHandlers(contextKey);
        int i = 0;
        while (i < ch.length) {
            if (ch[i].id().equals(id)) {
                return ch[i];
            }
            ++i;
        }
        return null;
    }

    protected Vector getContextHandlersByKey(String key) {
        Vector v = (Vector)this.contextHandlersByKey.get(key);
        if (v != null) {
            return v;
        }
        return new Vector();
    }

    protected IContextHandler[] internalGetContextHandlers(String contextKey) {
        Vector v;
        if (this.contextHandlersByKey == null) {
            this.initialize();
        }
        if (contextKey != null) {
            v = this.getContextHandlersByKey(contextKey);
        } else {
            v = new Vector();
            Iterator i = this.contextHandlersByKey.keySet().iterator();
            while (i.hasNext()) {
                v.addAll(this.getContextHandlersByKey((String)i.next()));
            }
        }
        IContextHandler[] contextHandlers = new IContextHandler[v != null ? v.size() : 0];
        if (v != null) {
            v.toArray(contextHandlers);
        }
        return contextHandlers;
    }

    public static IContextHandler[] getContextHandlers(String contextKey) {
        return ContextManager.instance().internalGetContextHandlers(contextKey);
    }

    protected IContextProvider internalGetContextProvider(String contextKey) {
        IContextHandler handler;
        if (contextKey == null) {
            return null;
        }
        if (this.contextHandlersByKey == null) {
            this.initialize();
        }
        if (this.contextMappingPreference.changed()) {
            this.contextMappingPreference.populateMappingByContext();
        }
        if ((handler = this.getContextHandlerById(contextKey, this.contextMappingPreference.getContextProviderId(contextKey))) != null) {
            return handler.getContextProvider();
        }
        return null;
    }

    public IContextProvider getContextProvider(String contextKey) {
        return ContextManager.instance().internalGetContextProvider(contextKey);
    }

    public IContextProvider getDefautProvider() {
        return this.getContextProvider(ContextManager.getDefautContext());
    }

    public static String getDefautContext() {
        return "Java";
    }

    protected boolean supportsAttribute(IContextProvider cp, String attribute) {
        String[] attrs = cp.getSupportAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].equals(attribute)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean supportsMode(IContextLabelFormatProvider clfp, int mode) {
        int[] modes = clfp.getSupportModes();
        int i = 0;
        while (i < modes.length) {
            if (modes[i] == mode) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IContextLabelFormatProvider internalGetContextLabelFormatProvider(String contextKey, String attribute, int mode) {
        IContextProvider cp = this.getContextProvider(contextKey);
        while (cp != null) {
            IContextLabelFormatProvider clfp;
            if (this.supportsAttribute(cp, attribute) && this.supportsMode(clfp = cp.getContextLabelFormatProvider(attribute), mode)) {
                return clfp;
            }
            cp = this.getContextProvider(cp.getBaseProvider());
        }
        return this.getDefautProvider().getContextLabelFormatProvider(attribute);
    }

    public static IContextLabelFormatProvider getContextLabelFormatProvider(String contextKey, String attribute, int mode) {
        return ContextManager.instance().internalGetContextLabelFormatProvider(contextKey, attribute, mode);
    }
}

