/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.util;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class LocationValidator {
    public static final String INVALID_PATH = "Invalid Path";

    public static String validateOSFileName(String valueStr) {
        if (valueStr.startsWith("-")) {
            return new Character(valueStr.charAt(0)).toString();
        }
        if (!Path.ROOT.isValidPath(valueStr)) {
            return INVALID_PATH;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(valueStr, 1);
        if (!result.isOK()) {
            return INVALID_PATH;
        }
        return LocationValidator.validateEMFSegment(valueStr);
    }

    public static String validatePath(IPath path) {
        int type = path.segmentCount() == 1 ? 4 : 2;
        return LocationValidator.validatePath(path, type);
    }

    public static String validatePath(IPath path, int type) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), type);
        if (!result.isOK()) {
            return INVALID_PATH;
        }
        if (!path.isValidPath(path.toString())) {
            return INVALID_PATH;
        }
        String[] segments = path.segments();
        int i = 0;
        int max = segments.length;
        while (i < max) {
            String invalidChar = LocationValidator.validateEMFSegment(segments[i]);
            if (invalidChar != null) {
                return invalidChar;
            }
            ++i;
        }
        return null;
    }

    public static String validateEMFSegment(String name) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            switch (ch) {
                case '<': {
                    return new Character(ch).toString();
                }
                case '>': {
                    return new Character(ch).toString();
                }
                case '+': {
                    return new Character(ch).toString();
                }
                case '|': {
                    return new Character(ch).toString();
                }
                case '{': {
                    return new Character(ch).toString();
                }
                case '}': {
                    return new Character(ch).toString();
                }
                case '[': {
                    return new Character(ch).toString();
                }
                case ']': {
                    return new Character(ch).toString();
                }
                case ':': {
                    return new Character(ch).toString();
                }
                case ';': {
                    return new Character(ch).toString();
                }
                case ',': {
                    return new Character(ch).toString();
                }
                case '\"': {
                    return new Character(ch).toString();
                }
                case '/': {
                    return new Character(ch).toString();
                }
                case '\\': {
                    return new Character(ch).toString();
                }
                case '\'': {
                    return new Character(ch).toString();
                }
                case '=': {
                    return new Character(ch).toString();
                }
                case '?': {
                    return new Character(ch).toString();
                }
                case '#': {
                    return new Character(ch).toString();
                }
                case '%': {
                    return new Character(ch).toString();
                }
                case '@': {
                    return new Character(ch).toString();
                }
                case '&': {
                    return new Character(ch).toString();
                }
                case '$': {
                    return new Character(ch).toString();
                }
                case '^': {
                    return new Character(ch).toString();
                }
            }
            ++i;
        }
        return null;
    }
}

