/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class PagesDialog
extends Dialog {
    protected ISDAdvancedPagingProvider provider = null;
    protected TextArea currentPage;
    protected Label totalPageComment;

    protected void updateComments() {
        int pages = Math.max(0, this.provider.pagesCount());
        String totalPageCommentText = String.valueOf(SDMessages._70) + pages + " ";
        totalPageCommentText = pages == 0 ? String.valueOf(totalPageCommentText) + SDMessages._71 : (pages == 1 ? String.valueOf(totalPageCommentText) + SDMessages._72 : String.valueOf(totalPageCommentText) + SDMessages._73);
        this.totalPageComment.setText(totalPageCommentText);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ret, "org.eclipse.hyades.ui.UML2SDPAGE");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        ret.setLayoutData((Object)data);
        ret.setText(SDMessages._67);
        FillLayout fillLayout = new FillLayout(512);
        ret.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)ret, 0);
        label.setText(SDMessages._75);
        this.currentPage = new TextArea((Composite)ret);
        this.currentPage.setBounds(1, this.provider.pagesCount());
        this.currentPage.setValue(this.provider.currentPage() + 1);
        this.totalPageComment = new Label((Composite)ret, 0);
        this.totalPageComment.setAlignment(131072);
        this.updateComments();
        this.getShell().setText(SDMessages._68);
        return ret;
    }

    public PagesDialog(IViewPart view_, ISDAdvancedPagingProvider loader_) {
        super(view_.getSite().getShell());
        this.provider = loader_;
        this.setShellStyle(67680);
    }

    public int open() {
        return super.open();
    }

    public void okPressed() {
        int currentPageValue = this.currentPage.getValue() - 1;
        super.close();
        this.provider.pageNumberChanged(currentPageValue);
    }

    protected class TextArea {
        protected Text text;
        int min;
        int max;

        public TextArea(Composite parent) {
            this.text = new Text(parent, 133124);
            this.text.setTextLimit(10);
        }

        public void setValue(int v) {
            int value = Math.max(this.min, Math.min(this.max, v));
            this.text.setText(Integer.toString(value));
        }

        public int getValue() {
            int res;
            try {
                res = Integer.parseInt(this.text.getText());
            }
            catch (Exception exception) {
                res = 0;
            }
            return Math.max(this.min, Math.min(this.max, res));
        }

        public void setBounds(int min_, int max_) {
            this.min = Math.max(0, min_);
            this.max = Math.max(this.min, max_);
            Object[] tab = new Integer[]{new Integer(this.min), new Integer(this.max)};
            this.text.setToolTipText(MessageFormat.format((String)SDMessages._69, (Object[])tab));
        }
    }
}

