/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.TabContents;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Stop;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.PlatformUI;

public class SearchFilterDialog
extends Dialog {
    protected static final String FIND_CRITERIA = "findCriteria";
    protected static final String FIND_EXPRESSION_LIST = "findExpressionList";
    protected static final String FILTER_CRITERIA = "filterCriteria";
    protected static final String FILTER_EXPRESSION_LIST = "filterExpressionList";
    protected static final int MAX_EXPRESSION_LIST = 7;
    protected SDView viewer = null;
    protected TabFolder tab = null;
    protected Criteria criteria = null;
    protected ISDGraphNodeSupporter provider = null;
    protected String okText;
    protected String title;
    protected String[] expressionList;
    protected boolean find;

    public Control createDialogArea(Composite arg0) {
        if (this.provider instanceof ISDFindProvider) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)arg0, "org.eclipse.hyades.ui.UML2SDFIND");
        } else if (this.provider instanceof ISDFilterProvider) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)arg0, "org.eclipse.hyades.ui.UML2SDFILTER");
        }
        this.expressionList = this.find ? CommonUIPlugin.getDefault().getDialogSettings().getArray(FIND_EXPRESSION_LIST) : CommonUIPlugin.getDefault().getDialogSettings().getArray(FILTER_EXPRESSION_LIST);
        if (this.expressionList == null) {
            this.expressionList = new String[0];
        }
        return new TabContents(arg0, this.provider, this.getButton(0), this.expressionList);
    }

    public SearchFilterDialog(SDView view_, ISDGraphNodeSupporter provider_, boolean filter_, int style) {
        super(view_.getSDWidget().getShell());
        this.setShellStyle(0x860 | style);
        this.provider = provider_;
        this.viewer = view_;
        this.find = !filter_;
    }

    public int open() {
        this.create();
        if (this.criteria == null) {
            this.loadCriteria();
        }
        if (this.criteria == null) {
            this.criteria = new Criteria();
            this.criteria.setLifeLineSelected(this.provider.isNodeSupported(0));
            this.criteria.setSyncMessageSelected(this.provider.isNodeSupported(1));
            this.criteria.setSyncMessageReturnSelected(this.provider.isNodeSupported(2));
            this.criteria.setAsyncMessageSelected(this.provider.isNodeSupported(3));
            this.criteria.setAsyncMessageReturnSelected(this.provider.isNodeSupported(4));
            this.criteria.setStopSelected(this.provider.isNodeSupported(5));
        }
        this.copyFromCriteria(this.criteria);
        if (this.okText != null) {
            this.getButton(0).setText(this.okText);
        } else {
            this.getButton(0).setText(SDMessages._21);
        }
        if (this.find) {
            this.getButton(1).setText(SDMessages._22);
        }
        Button okButton = this.getButton(0);
        ((TabContents)this.getDialogArea()).setOkButton(okButton);
        if (!(this.criteria != null && this.criteria.getExpression() != null && !this.criteria.getExpression().equals("") && (this.criteria.isAsyncMessageReturnSelected() || this.criteria.isAsyncMessageSelected() || this.criteria.isLifeLineSelected() || this.criteria.isStopSelected() || this.criteria.isSyncMessageReturnSelected() || this.criteria.isSyncMessageSelected()))) {
            okButton.setEnabled(false);
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(SDMessages._24);
        }
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        this.criteria = null;
        return super.open();
    }

    protected void loadCriteria() {
        String CRITERIA = FIND_CRITERIA;
        if (!this.find) {
            CRITERIA = FILTER_CRITERIA;
        }
        DialogSettings section = (DialogSettings)CommonUIPlugin.getDefault().getDialogSettings().getSection(CRITERIA);
        List selection = this.viewer.getSDWidget().getSelection();
        if (selection == null || selection.size() != 1 || !this.find) {
            if (section != null) {
                this.criteria = new Criteria();
                this.criteria.load(section);
            }
        } else {
            GraphNode gn = (GraphNode)selection.get(0);
            this.criteria = new Criteria();
            this.criteria.setExpression(gn.getName());
            this.criteria.setCaseSenstiveSelected(true);
            if (gn instanceof Lifeline && this.provider.isNodeSupported(0)) {
                this.criteria.setLifeLineSelected(true);
            } else if (gn instanceof SyncMessageReturn && this.provider.isNodeSupported(2)) {
                this.criteria.setSyncMessageReturnSelected(true);
            } else if ((gn instanceof SyncMessageReturn || gn instanceof SyncMessage) && this.provider.isNodeSupported(1)) {
                this.criteria.setSyncMessageSelected(true);
            } else if (gn instanceof AsyncMessageReturn && this.provider.isNodeSupported(4)) {
                this.criteria.setAsyncMessageReturnSelected(true);
            } else if ((gn instanceof AsyncMessageReturn || gn instanceof AsyncMessage) && this.provider.isNodeSupported(3)) {
                this.criteria.setAsyncMessageSelected(true);
            } else if (gn instanceof Stop && this.provider.isNodeSupported(5)) {
                this.criteria.setStopSelected(true);
            }
        }
    }

    public void okPressed() {
        this.copyToCriteria();
        if (!this.find) {
            this.saveCriteria();
            super.close();
        }
        if (this.provider != null && this.provider instanceof ISDFindProvider && this.find) {
            boolean result = ((ISDFindProvider)this.provider).find(this.criteria);
            TabContents content = this.getTabContents();
            content.setResult(result);
        }
    }

    public void cancelPressed() {
        if (this.find) {
            this.copyToCriteria();
            if (this.provider instanceof ISDFindProvider) {
                ((ISDFindProvider)this.provider).cancel();
            }
            this.saveCriteria();
        }
        super.cancelPressed();
    }

    public void saveCriteria() {
        DialogSettings settings;
        DialogSettings section;
        String CRITERIA = FIND_CRITERIA;
        String EXPRESSION_LIST = FIND_EXPRESSION_LIST;
        if (!this.find) {
            CRITERIA = FILTER_CRITERIA;
            EXPRESSION_LIST = FILTER_EXPRESSION_LIST;
        }
        if ((section = (DialogSettings)(settings = (DialogSettings)CommonUIPlugin.getDefault().getDialogSettings()).getSection(CRITERIA)) == null) {
            section = (DialogSettings)settings.addNewSection(CRITERIA);
        }
        this.criteria.save(section);
        if (this.criteria.getExpression().length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.expressionList.length) {
                list.add(this.expressionList[i]);
                ++i;
            }
            list.remove(this.criteria.getExpression());
            list.add(0, this.criteria.getExpression());
            int size = Math.min(list.size(), 7);
            String[] temp = new String[size];
            int i2 = 0;
            while (i2 < size) {
                temp[i2] = (String)list.get(i2);
                ++i2;
            }
            this.expressionList = temp;
            settings.put(EXPRESSION_LIST, this.expressionList);
        }
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria_) {
        this.criteria = criteria_;
    }

    public void copyToCriteria() {
        this.criteria = new Criteria();
        TabContents content = this.getTabContents();
        this.criteria.setLifeLineSelected(content.getLifelineButtonSelection());
        this.criteria.setSyncMessageSelected(content.getSynMessageButtonSelection());
        this.criteria.setSyncMessageReturnSelected(content.getSynMessageReturnButtonSelection());
        this.criteria.setAsyncMessageSelected(content.getAsynMessageButtonSelection());
        this.criteria.setAsyncMessageReturnSelected(content.getAsynMessageReturnButtonSelection());
        this.criteria.setStopSelected(content.getStopButtonSelection());
        this.criteria.setCaseSenstiveSelected(content.getCaseSensitiveSelection());
        this.criteria.setExpression(content.getSearchText());
    }

    protected TabContents getTabContents() {
        TabContents content = null;
        content = this.tab == null ? (TabContents)this.getDialogArea() : (TabContents)this.tab.getSelection()[0].getControl();
        return content;
    }

    public void copyFromCriteria(Criteria from) {
        TabContents content = this.getTabContents();
        content.setLifelineButtonSelection(from.isLifeLineSelected());
        content.setSynMessageButtonSelection(from.isSyncMessageSelected());
        content.setSynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
        content.setAsynMessageButtonSelection(from.isAsyncMessageSelected());
        content.setAsynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
        content.setStopButtonSelection(from.isStopSelected());
        content.setCaseSensitiveSelection(from.isCaseSenstiveSelected());
        if (from.getExpression() != null) {
            content.setSearchText(from.getExpression());
        }
    }

    public void setOkText(String okText_) {
        this.okText = okText_;
    }

    public void setTitle(String title_) {
        this.title = title_;
    }
}

