/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.Comparator;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.util.SortSyncMessageComparator;

public class SyncMessage
extends BaseMessage
implements ITimeRange {
    protected SyncMessageReturn messageReturn;
    protected double eventTime = 0.0;
    public static final String SYNC_MESS_TAG = "SyncMessage";
    protected boolean hasTime = false;

    public SyncMessage() {
        this.prefId = "PREF_SYNC_MESS";
    }

    protected void syncLifelinesEventOccurrence() {
        if (this.getStartLifeline() != null && this.getEndLifeline() != null) {
            int newIndex = 0;
            newIndex = this.getStartLifeline().getEventOccurrence() > this.getEndLifeline().getEventOccurrence() ? this.getStartLifeline().getEventOccurrence() : this.getEndLifeline().getEventOccurrence();
            this.getStartLifeline().setCurrentEventOccurrence(newIndex);
            this.getEndLifeline().setCurrentEventOccurrence(newIndex);
            this.setEventOccurrence(this.getStartLifeline().getEventOccurrence());
        }
    }

    public void autoSetStartLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setStartLifeline(lifeline);
    }

    public void autoSetEndLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setEndLifeline(lifeline);
    }

    public void setStartLifeline(Lifeline lifeline) {
        super.setStartLifeline(lifeline);
        if (this.getEndLifeline() == null) {
            this.setEventOccurrence(this.getStartLifeline().getEventOccurrence());
        } else {
            this.syncLifelinesEventOccurrence();
        }
    }

    public void setEndLifeline(Lifeline lifeline) {
        super.setEndLifeline(lifeline);
        if (this.getStartLifeline() == null) {
            this.setEventOccurrence(this.getEndLifeline().getEventOccurrence());
        } else {
            this.syncLifelinesEventOccurrence();
        }
    }

    protected void setEventOccurrence(int occurrence) {
        this.startEventOccurrence = occurrence;
        this.endEventOccurrence = occurrence;
    }

    protected void setMessageReturn(SyncMessageReturn message) {
        this.messageReturn = message;
    }

    public SyncMessageReturn getMessageReturn() {
        return this.messageReturn;
    }

    public void setTime(double time) {
        this.eventTime = time;
        this.hasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    public double getLastTime() {
        return this.eventTime;
    }

    public double getFirstTime() {
        return this.eventTime;
    }

    public boolean hasTimeInfo() {
        return this.hasTime;
    }

    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isSelected()) {
            context.setBackground(Frame.getUserPref().getBackGroundColor(this.prefId));
            context.setForeground(Frame.getUserPref().getForeGroundColor(this.prefId));
        }
        super.draw(context);
    }

    public boolean isVisible(int x, int y, int width, int height) {
        if (this.getY() > y + height + 10 + Metrics.getMessageFontHeigth()) {
            return false;
        }
        if ((this.endLifeline == null && this.startLifeline != null || this.endLifeline != null && this.startLifeline == null) && x + width > this.getX() + this.getWidth() && x < this.getX() + this.getWidth()) {
            return true;
        }
        return super.isVisible(x, y, width, height);
    }

    public Comparator getComparator() {
        return new SortSyncMessageComparator();
    }

    public String getArrayId() {
        return SYNC_MESS_TAG;
    }

    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getY() > y;
    }
}

