/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.DebugUtil;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;

public class LoadersManager {
    protected static LoadersManager loadersManager;
    protected static HashMap map;

    public LoadersManager() {
        map = new HashMap();
    }

    public static LoadersManager getLoadersManager() {
        if (loadersManager == null) {
            loadersManager = ICommonUIHelper.INSTANCE.createLoadersManager();
        }
        return loadersManager;
    }

    public IUml2SDLoader createLoader(String className, ClassLoader cl, SDView view) {
        IUml2SDLoader loader = this.createLoaderInstance(className, cl);
        this.associateLoader(loader, view);
        return loader;
    }

    public IUml2SDLoader createLoaderInstance(String className, ClassLoader cl) {
        IUml2SDLoader loader = null;
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(className);
            loader = (IUml2SDLoader)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return loader;
    }

    public void associateLoader(IUml2SDLoader loader, SDView view) {
        if (view != null) {
            this.setCurrentLoader(loader, view.getViewSite().getId());
        }
        if (loader != null) {
            loader.setViewer(view);
        }
    }

    public void setCurrentLoader(IUml2SDLoader loader, String id) {
        if (id == null) {
            return;
        }
        IUml2SDLoader currentLoader = null;
        if (map.get(id) instanceof IUml2SDLoader) {
            currentLoader = (IUml2SDLoader)map.get(id);
        }
        if (currentLoader != null && currentLoader != loader) {
            if (loader != null) {
                IWorkbenchPage persp = CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    SDView sdview = null;
                    IViewReference viewref = persp.findViewReference(id);
                    if (viewref != null) {
                        sdview = (SDView)viewref.getView(false);
                    }
                    if (sdview != null) {
                        sdview.resetProviders();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            currentLoader.aboutToBeReplaced();
        }
        map.put(id, loader);
        if (loader != null && id != null) {
            SDUtil.getInstance().setLastLoader(loader.getClass().getName(), id);
        }
    }

    public void resetLoader(String viewId) {
        IUml2SDLoader loader = (IUml2SDLoader)map.get(viewId);
        if (loader != null) {
            loader.aboutToBeReplaced();
        }
        map.put(viewId, null);
        BackgroundLoader.setView(null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId) {
        return this.getCurrentLoader(viewId, null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId, SDView view) {
        block8: {
            if (viewId == null) {
                return null;
            }
            IWorkbenchPage persp = CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (view != null) break block8;
                SDView v = null;
                IViewReference viewref = persp.findViewReference(viewId);
                if (viewref != null) {
                    v = (SDView)viewref.getView(false);
                }
                if (v != null) break block8;
                return null;
            }
            catch (Exception e) {
                if (DebugUtil.debug()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        Object loader = map.get(viewId);
        if (loader == null) {
            this.createLastLoaderIfAny(viewId);
            loader = map.get(viewId);
        }
        if (loader instanceof IUml2SDLoader) {
            BackgroundLoader.setView(view);
            return (IUml2SDLoader)loader;
        }
        return null;
    }

    protected void createLastLoaderIfAny(String viewId) {
        String loader = SDUtil.getInstance().getSavedLoader(viewId);
        IConfigurationElement ce2 = null;
        List loaders = SDUtil.getLoaders(viewId);
        if (loader != null && loader.length() > 0) {
            for (IConfigurationElement ce2 : loaders) {
                if (!ce2.getAttribute("class").equals(loader)) {
                    ce2 = null;
                    continue;
                }
                break;
            }
        } else {
            for (IConfigurationElement ce2 : loaders) {
                if (!Boolean.valueOf(ce2.getAttribute("default")).booleanValue()) {
                    ce2 = null;
                    continue;
                }
                break;
            }
        }
        if (ce2 != null) {
            SDUtil.createLoaderForView(viewId, ce2);
        }
    }
}

