/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.util;

import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.hyades.uml2sd.util.TimeUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MinMaxDialog
extends Dialog {
    protected Label minLabel;
    protected Label maxLabel;
    protected Text minText;
    protected Text maxText;
    protected Combo unit1;
    protected Combo unit2;
    SDWidget sdWidget;

    public MinMaxDialog(Shell s, SDWidget v) {
        super(s);
        this.sdWidget = v;
    }

    protected GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(SDMessages._123);
        Composite parent = (Composite)super.createDialogArea(p);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 6;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setLayoutData((Object)this.newGridData(3));
        GridLayout g1layout = new GridLayout();
        g1layout.numColumns = 3;
        g1.setLayout((Layout)g1layout);
        this.minLabel = new Label((Composite)g1, 16);
        this.minLabel.setText(SDMessages._124);
        this.minLabel.setLayoutData((Object)this.newGridData(1));
        this.minText = new Text((Composite)g1, 2052);
        this.minText.setLayoutData((Object)this.newGridData(1));
        this.minText.setText(TimeUtil.deltaToString(this.sdWidget.getFrame().getMinTime()));
        this.unit1 = new Combo((Composite)g1, 8);
        this.unit1.add(TimeUtil.deltaNormalString[0], 0);
        this.unit1.add(TimeUtil.deltaNormalString[1], 1);
        this.unit1.add(TimeUtil.deltaNormalString[2], 2);
        this.unit1.add(TimeUtil.deltaNormalString[3], 3);
        this.unit1.add(TimeUtil.deltaNormalString[4], 4);
        this.unit1.add(TimeUtil.deltaNormalString[5], 5);
        this.unit1.select(TimeUtil.deltaUnit(this.sdWidget.getFrame().getMinTime()));
        this.maxLabel = new Label((Composite)g1, 16);
        this.maxLabel.setText(SDMessages._125);
        this.maxLabel.setLayoutData((Object)this.newGridData(1));
        this.maxText = new Text((Composite)g1, 2052);
        this.maxText.setLayoutData((Object)this.newGridData(1));
        this.maxText.setText(TimeUtil.deltaToString(this.sdWidget.getFrame().getMaxTime()));
        this.unit2 = new Combo((Composite)g1, 8);
        this.unit2.add(TimeUtil.deltaNormalString[0], 0);
        this.unit2.add(TimeUtil.deltaNormalString[1], 1);
        this.unit2.add(TimeUtil.deltaNormalString[2], 2);
        this.unit2.add(TimeUtil.deltaNormalString[3], 3);
        this.unit2.add(TimeUtil.deltaNormalString[4], 4);
        this.unit2.add(TimeUtil.deltaNormalString[5], 5);
        this.unit2.select(TimeUtil.deltaUnit(this.sdWidget.getFrame().getMaxTime()));
        return parent;
    }

    protected double applyUnit(double value, Combo unit) {
        switch (unit.getSelectionIndex()) {
            case 0: {
                return value * 24.0 * 60.0 * 60.0;
            }
            case 1: {
                return value * 60.0 * 60.0;
            }
            case 2: {
                return value * 60.0;
            }
            case 3: {
                return value;
            }
            case 4: {
                return value / 1000.0;
            }
        }
        return value / 1000000.0;
    }

    protected void okPressed() {
        double min = 0.0;
        double max = 0.0;
        try {
            min = Double.parseDouble(this.minText.getText());
            max = Double.parseDouble(this.maxText.getText());
            this.sdWidget.getFrame().setMax(this.applyUnit(max, this.unit2));
            this.sdWidget.getFrame().setMin(this.applyUnit(min, this.unit1));
            this.sdWidget.redraw();
            super.okPressed();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._99);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1024, SDMessages._126, false);
        this.getButton(1024).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MinMaxDialog.this.sdWidget.getFrame().resetCustomMinMax();
                MinMaxDialog.this.minText.setText(TimeUtil.deltaToString(MinMaxDialog.this.sdWidget.getFrame().getMinTime()));
                MinMaxDialog.this.maxText.setText(TimeUtil.deltaToString(MinMaxDialog.this.sdWidget.getFrame().getMaxTime()));
                MinMaxDialog.this.unit1.select(TimeUtil.deltaUnit(MinMaxDialog.this.sdWidget.getFrame().getMinTime()));
                MinMaxDialog.this.unit2.select(TimeUtil.deltaUnit(MinMaxDialog.this.sdWidget.getFrame().getMaxTime()));
                MinMaxDialog.this.maxText.getParent().layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

