/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.internal.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;

public class CommonPageSizeUI
implements ModifyListener {
    protected PreferencePage parent = null;
    protected String labelText = null;
    protected String info = null;
    protected String contextHelpID = null;
    protected Text txtPageSize = null;
    protected String initValue = "";

    public CommonPageSizeUI(PreferencePage parent, String info, String labelText, String contextHelpID, String initValue) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)labelText);
        this.parent = parent;
        this.labelText = labelText;
        this.info = info;
        this.contextHelpID = contextHelpID;
        this.initValue = initValue;
    }

    public Control createContents(Composite parentComposite) {
        Composite composite = new Composite(parentComposite, 0);
        if (this.contextHelpID != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.parent.getControl(), this.contextHelpID);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        if (this.info != null) {
            Label note = new Label(composite, 64);
            note.setText(this.info);
            data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 375;
            note.setLayoutData((Object)data);
        }
        Label dummy = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        dummy.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(this.labelText);
        this.txtPageSize = new Text(composite, 2048);
        this.txtPageSize.setTextLimit(5);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(7, (Control)parentComposite);
        this.txtPageSize.setLayoutData((Object)data);
        this.txtPageSize.setText(this.initValue != null ? this.initValue : "");
        this.txtPageSize.addModifyListener((ModifyListener)this);
        return composite;
    }

    protected int convertWidthInCharsToPixels(int chars, Control parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    public String getPageSize() {
        return this.txtPageSize.getText();
    }

    public void setPageSize(String newValue) {
        if (newValue == null) {
            return;
        }
        this.txtPageSize.setText(newValue);
    }

    public void modifyText(ModifyEvent e) {
        IStatus status = this.validateInput();
        this.parent.setValid(status.getSeverity() == 0);
        if (status.getSeverity() == 4) {
            this.parent.setErrorMessage(status.getMessage());
        } else {
            this.parent.setErrorMessage(null);
        }
    }

    protected IStatus validateInput() {
        String nrOfPages = this.txtPageSize.getText();
        PreferenceStatus status = new PreferenceStatus();
        if (nrOfPages.length() == 0) {
            status.setMessage(CommonUIMessages.emptyPageSizeErr);
            status.setSeverity(4);
        } else {
            try {
                int value = Integer.parseInt(nrOfPages);
                if (value <= 0) {
                    status.setMessage(NLS.bind((String)CommonUIMessages.invalidPageSizeErr, (Object[])new String[]{nrOfPages}));
                    status.setSeverity(4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setMessage(NLS.bind((String)CommonUIMessages.invalidPageSizeErr, (Object[])new String[]{nrOfPages}));
                status.setSeverity(4);
            }
        }
        return status;
    }

    class PreferenceStatus
    extends Status {
        public PreferenceStatus() {
            super(0, "tptp.platform.common.ui", 0, "", null);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }

        protected void setSeverity(int severity) {
            super.setSeverity(severity);
        }
    }
}

