/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyFactoryImpl;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.TraceSelection;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class TraceUIManager
implements ISelectionChangedListener {
    protected ResourceSet resourceSet;
    protected HierarchyFactory factory;
    protected static TraceUIManager traceUIManager;
    protected ProfileEvent fProfileEvent = new ProfileEvent();
    protected ListenerList fProfileEventListeners = new ListenerList();
    protected ArrayList fDeleteListener = new ArrayList(1);
    protected HashMap fSelectionModel = new HashMap();
    protected List fSelectionProviders = new ArrayList(2);
    protected List fSelectionParts = new ArrayList(2);
    protected ListenerList fListeners = new ListenerList();
    protected ProfileEvent refreshViewsEvent = new ProfileEvent(64);
    protected ProfileEvent refreshOptionEvent = new ProfileEvent(80);
    protected ViewSelectionChangedEvent pdViewEvent = new ViewSelectionChangedEvent();
    protected ListenerList fPDViewEventListeners = new ListenerList();
    protected ProfileEvent updateModelEvent = new ProfileEvent(32);
    protected ProfileEvent contextHandlerSelectionChangedEvent = new ProfileEvent(6144);

    protected TraceUIManager() {
    }

    public void addSelectionListener(ISelectionListener l) {
        this.fListeners.add((Object)l);
    }

    public void removeSelectionListener(ISelectionListener l) {
        this.fListeners.remove((Object)l);
    }

    public static TraceUIManager getTraceUIManager() {
        if (traceUIManager == null) {
            traceUIManager = new TraceUIManager();
        }
        return traceUIManager;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            HierarchyPackageImpl.init();
            this.factory = new HierarchyFactoryImpl();
            this.resourceSet = HierarchyResourceSetImpl.getInstance();
        }
        return this.resourceSet;
    }

    public ProfileEvent getProfileEvent() {
        return this.fProfileEvent;
    }

    public void notifyProfileEventListener(final ProfileEvent event) {
        CommonUIPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Object[] listeners = TraceUIManager.this.fProfileEventListeners.getListeners();
                int idx = 0;
                while (idx < listeners.length) {
                    ((IProfileEventListener)listeners[idx]).handleProfileEvent(event);
                    ++idx;
                }
            }
        });
    }

    public ArrayList getDeleteListeners() {
        return this.fDeleteListener;
    }

    public void addDeleteListener(IDeleteListener listener) {
        this.fDeleteListener.add(listener);
    }

    public void removeDeleteListener(IDeleteListener listener) {
        this.fDeleteListener.remove(listener);
    }

    public ITraceSelection getSelectionModel(EObject mofObject) {
        Object model = this.fSelectionModel.get(mofObject);
        if (model == null) {
            model = new TraceSelection();
            this.fSelectionModel.put(mofObject, model);
        }
        return (ITraceSelection)model;
    }

    public void addSelectionModel(EObject mofObject, ITraceSelection model) {
        this.fSelectionModel.put(mofObject, model);
    }

    public void removeSelectionModel(EObject mofObject) {
        this.fSelectionModel.remove(mofObject);
    }

    public void addProfileEventListener(IProfileEventListener listener) {
        this.fProfileEventListeners.add((Object)listener);
    }

    public void removeProfileEventListener(IProfileEventListener listener) {
        this.fProfileEventListeners.remove((Object)listener);
    }

    public void dispose() {
        this.fListeners.clear();
        this.fDeleteListener.clear();
        this.resourceSet = null;
        this.factory = null;
        this.fSelectionParts.clear();
        this.fDeleteListener.clear();
        this.fProfileEventListeners.clear();
        this.fSelectionModel.clear();
        this.fProfileEvent = null;
        this.refreshViewsEvent = null;
        traceUIManager = null;
        this.pdViewEvent = null;
        this.updateModelEvent = null;
        this.contextHandlerSelectionChangedEvent = null;
        this.fPDViewEventListeners.clear();
        this.fSelectionProviders.clear();
    }

    public void addSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        this.fSelectionProviders.add(provider);
        this.fSelectionParts.add(part);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void removeSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        this.fSelectionProviders.remove(provider);
        this.fSelectionParts.remove(part);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged(null);
    }

    protected static ISelection convertNavigatorItems(ISelection sel) {
        if (sel != null && sel instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)sel;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object obj : s) {
                if (obj instanceof INavigatorItem) {
                    list.add(((INavigatorItem)obj).getData());
                    continue;
                }
                list.add(obj);
            }
            return new StructuredSelection(list);
        }
        return sel;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        int index;
        Object[] copiedListeners = this.fListeners.getListeners();
        ISelection selection = null;
        ISelectionProvider provider = null;
        IWorkbenchPart part = null;
        if (event != null) {
            selection = TraceUIManager.convertNavigatorItems(event.getSelection());
            provider = (ISelectionProvider)event.getSource();
            index = this.fSelectionProviders.indexOf(provider);
            if (index == -1) {
                return;
            }
        } else {
            return;
        }
        part = (IWorkbenchPart)this.fSelectionParts.get(index);
        this.selectionChanged(part, selection);
        int i = 0;
        while (i < copiedListeners.length) {
            ISelectionListener l = (ISelectionListener)copiedListeners[i];
            l.selectionChanged(part, selection);
            ++i;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
    }

    public ProfileEvent getRefreshViewEvent(Object source) {
        this.refreshViewsEvent.setSource(source);
        return this.refreshViewsEvent;
    }

    public ProfileEvent getRefreshOptionEvent(Object source) {
        this.refreshOptionEvent.setSource(source);
        return this.refreshOptionEvent;
    }

    public HierarchyFactory getPerftraceFactory() {
        return this.factory;
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return this.pdViewEvent;
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
        Object[] listeners = this.fPDViewEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IViewSelectionChangedListener)listeners[idx]).handleViewSelectionChangedEvent(event);
            ++idx;
        }
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        this.fPDViewEventListeners.add((Object)listener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        this.fPDViewEventListeners.remove((Object)listener);
    }

    public ProfileEvent getUpdateModelEvent(Object source) {
        this.updateModelEvent.setSource(source);
        return this.updateModelEvent;
    }

    public ProfileEvent getContextHandlerSelectionChangedEvent(Object source) {
        this.contextHandlerSelectionChangedEvent.setSource(source);
        return this.contextHandlerSelectionChangedEvent;
    }
}

