/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.views.TableCellLabelProvider;

public class TableCellLabelProviderManager {
    protected static TableCellLabelProviderManager instance;
    protected final String PROVIDER_EXTENSION_POINT = "TableCellLabelProviders";
    protected final String PROVIDER_EXTENSION_POINT_ELEMENT = "tableCellLabelProvider";
    protected Map providersByColumnKey;

    public static TableCellLabelProviderManager instance() {
        if (instance == null) {
            instance = new TableCellLabelProviderManager();
        }
        return instance;
    }

    protected void initializeProviders() {
        this.providersByColumnKey = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.common.ui", "TableCellLabelProviders");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                if (elem.getName().equals("tableCellLabelProvider")) {
                    String id = elem.getAttribute("id");
                    TableCellLabelProvider tableCellLabelProvider = null;
                    String[] keys = null;
                    try {
                        if (!"".equals(elem.getAttribute("class"))) {
                            Object clz = elem.createExecutableExtension("class");
                            if (clz instanceof TableCellLabelProvider) {
                                tableCellLabelProvider = (TableCellLabelProvider)clz;
                                keys = tableCellLabelProvider.getSupportColumnKeys();
                            } else {
                                CommonPlugin.logError((String)"Class in extension point org.eclipse.tptp.platform.common.uiTableCellLabelProviders must implement TableCellLabelProvider");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (id != null && tableCellLabelProvider != null && keys != null) {
                        int j = 0;
                        while (j < keys.length) {
                            String colID = keys[j];
                            Vector<TableCellLabelProvider> providerList = (Vector<TableCellLabelProvider>)this.providersByColumnKey.get(colID);
                            if (providerList == null) {
                                providerList = new Vector<TableCellLabelProvider>();
                                providerList.add(tableCellLabelProvider);
                                this.providersByColumnKey.put(colID, providerList);
                            } else {
                                providerList.add(tableCellLabelProvider);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void initialize() {
        this.initializeProviders();
    }

    protected Vector getProvidersByColID(String colID) {
        if (this.providersByColumnKey == null) {
            this.initialize();
        }
        Vector v = (Vector)this.providersByColumnKey.get(colID);
        return v;
    }

    public static Vector getProvidersByColIDLKey(String colID) {
        return TableCellLabelProviderManager.instance().getProvidersByColID(colID);
    }
}

