/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.internal;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.util.ILogger;
import org.osgi.framework.BundleContext;

public class CommonPlugin
extends Plugin {
    protected static final String KEYSTORE = "keystore.dat";
    public static final String PLUGIN_ID = "org.eclipse.tptp.platform.common";
    protected static CommonPlugin plugin;
    protected ILogger logger;

    public CommonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.logger = null;
        super.stop(context);
    }

    public static void logInfo(String message) {
        CommonPlugin.log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void logError(String message) {
        CommonPlugin.log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logError(Throwable throwable) {
        CommonPlugin.log((IStatus)new Status(4, PLUGIN_ID, throwable.toString(), throwable));
    }

    public static void logError(IStatus status) {
        CommonPlugin.log(status);
    }

    public static void log(IStatus status) {
        CommonPlugin.getDefault().getLog().log(status);
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public static ILogger getLogger() {
        if (CommonPlugin.plugin.logger == null) {
            CommonPlugin.plugin.logger = new ILogger(){

                public void logError(Throwable throwable) {
                    this.logError(throwable);
                }

                public void logError(String text) {
                    this.logError(text);
                }

                public void logInfo(String text) {
                    this.logInfo(text);
                }
            };
        }
        return CommonPlugin.plugin.logger;
    }

    public static IWorkspaceRoot getRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String getKeyStoreLocation() {
        return Platform.getPluginStateLocation((Plugin)plugin).append(KEYSTORE).toOSString();
    }
}

